<?php
session_start();
include('includes/config.inc.php');
if(!isset($_COOKIE['gjuha'])){
	setcookie('gjuha', DEFAULT_LANG, time()+60*60*24*30);
	$lang = DEFAULT_LANG;
} else{
	$lang = $_COOKIE['gjuha'];
}
if(isset($_GET['gj'])){
	if($_GET['gj'] != 'al' and $_GET['gj'] != 'en'){
		$lang = DEFAULT_LANG;
		setcookie('gjuha', DEFAULT_LANG, time()+60*60*24*30);
	} else{
		$lang = $_GET['gj'];
		setcookie('gjuha', $_GET['gj'], time()+60*60*24*30);
	}
}
define('URL', 'http://www.al-tek.biz/');
?>
<!--
Design and Programming by: Fadion Dashi
-->
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="description" content="<?php echo META_DESCRIPTION; ?>" />
<meta name="keywords" content="<?php echo META_KEYWORDS; ?>" />
<meta name="author" content="Fadion Dashi" />
<title>
<?php
if(isset($_GET['fq'])){
	if($_GET['fq'] != 'kompania' and $_GET['fq'] != 'produktet' and $_GET['fq'] != 'kontakt' and $_GET['fq'] != 'sitemap' and $_GET['fq'] != 'rezervuar' and $_GET['fq'] != 'partneret'){
		echo SITE_TITLE;
	} else{
		if($lang == 'al'){
			echo SITE_TITLE . ' :: ' . ucfirst($_GET['fq']);
		} else{
			switch ($_GET['fq']){
			case 'kompania':
				echo SITE_TITLE . ' :: Company';
				break;
			case 'produktet':
				echo SITE_TITLE . ' :: Products';
				break;
			case 'kontakt';
				echo SITE_TITLE . ' :: Contact';
				break;
			case 'sitemap';
				echo SITE_TITLE . ' :: Sitemap';
				break;
			case 'rezervuar';
				echo SITE_TITLE . ' :: Reserved';
			case 'partneret';
				echo SITE_TITLE . ' :: Partners';
			}
		}
	}
} else{
	echo SITE_TITLE;
}
?>
</title>
<link rel="stylesheet" type="text/css" href="<?php echo URL; ?>styles/main.css" />
</head>

<body>
<div id="menuWrapper">
<?php
if($lang == 'en'){ 
	include('includes/menu-en.inc.php');
} else{
	include('includes/menu-al.inc.php');
}
?>
</div>
<div id="mainWrapper">
	<div id="innerWrapper">
		<div id="header"> <!-- start header -->
		<?php
        if($lang == 'en'){
        	include('includes/header-en.inc.php');
        } else{
        	include('includes/header-al.inc.php');
        }
        ?>
        </div> <!-- end header -->
        <div id="contentWrapper">
        	<div id="sidebar"> <!-- start sidebar -->
				<?php
				if($lang == 'en'){
					include('includes/sidebar-en.inc.php');
				} else{
					include('includes/sidebar-al.inc.php');
				}
				?>
          	</div> <!-- end sidebar -->
            <div id="content"> <!-- start content -->
            <?php
			if(isset($_GET['fq'])){
				if($_GET['fq'] != 'kompania' and $_GET['fq'] != 'produktet' and $_GET['fq'] != 'kontakt' and $_GET['fq'] != 'sitemap' and $_GET['fq'] != 'rezervuar' and $_GET['fq'] != 'partneret'){
					include('includes/home.inc.php');
				} else{
					if($_GET['fq'] == 'produktet' and $lang == 'en'){
						include('includes/produktet-en.inc.php');
					} elseif($_GET['fq'] == 'produktet' and $lang == 'al'){
						include('includes/produktet-al.inc.php');
					} else{
						include('includes/' . $_GET['fq'] . '.inc.php');
					}
				}
			} else{
				include('includes/home.inc.php');
			}
			?>
            </div> <!-- end content -->
        </div>
	</div>
    	<div id="emptyContainer">
        &nbsp;
        </div>
        <div id="footer"> <!-- start footer -->
        <?php
		if($lang == 'en'){
			include('includes/footer-en.inc.php');
		} else{
			include('includes/footer-al.inc.php');
		}
		?>
        </div> <!-- end footer -->
</div>
<?php include('includes/analytics.inc.php'); ?>
</body>
</html>