<?php
class URL {
	
	public $ref = '';
	
	public function __construct () {
		$this->ref = $this->setReferal();
	}
	
	private function setReferal () {
		$ref = $_SERVER['HTTP_REFERER'];
		$whitelist = array('faqet', 'kategorite', 'produktet', 'redaktoret');
		
		if (preg_match('|f=[a-z0-9-]+|i', $ref, $matches)) {
			$f = substr($matches[0], 2);
			
			if (in_array($f, $whitelist)) {
				$_SESSION['ref'] = $ref;
				return $ref;
			} else {
				return $_SESSION['ref'];
			}
		}
	}
	
	public function qs () {
		if (!func_num_args()) {
			return false;
		}
		
		$args = func_get_args();
		$qs = $_SERVER['QUERY_STRING'];
		
		foreach ($args as $remove) {
			$qs = preg_replace("|&$remove=(.*)|", '', $qs);
		}
		
		return $qs;
	}
	
	public function fqs () {
		if (!func_num_args()) {
			return false;
		}
		
		$args = func_get_args();
		$qs = $_SERVER['QUERY_STRING'];
		$url = '';
		
		foreach ($args as $remove) {
			$qs = preg_replace("|&$remove=(.*)|", '', $qs);
		}
		
		$qs = explode('&', $qs);
		foreach ($qs as $prm) {
			list($name, $value) = explode('=', $prm);
			$path .= "$value/";
		}
		
		return $path;
	}
	
	public function seo ($string) {
		if ($string == '') {
			return false;
		}
		
		$special = array('ç', 'Ç', 'ë', 'Ë');
		$special_replace = array('c', 'C', 'e', 'E');
		
		$string = strtolower($string);
		$string = str_replace(' ', '-', $string);
		$string = str_replace($special, $special_replace, $string);
		$string = preg_replace('|[^a-z0-9-]|i', '', $string);
		
		return $string;
	}
	
}