<?php
class fPagination {
	
	public $items = 15;
	public $page = 1;
	public $start;
	public $total;
	
	public function setLimits () {
		if (!isset($_GET['faqja']) or (int) $_GET['faqja'] == 0) {
			$this->page = 1;
		} else {
			$this->page = (int) $_GET['faqja'];
		}
		
		$this->start = ($this->page * $this->items) - $this->items;
	}
	
	public function showPages () {
		$db = new DB;
		$url = new URL;
		
		$results = $db->query($this->total);
	
		if (!$results->num_rows()) {
			return false;
		}
		
		$this->total = $results->num_rows();
		$total_pages = ceil($this->total / $this->items);
		
		echo '<div id="pagination">';
		echo '<ul>';
		
		if ($this->page != 1) {
			$next = $this->page - 1;
			echo '<li class="previous"><a href="admin.php?' . $url->qs('faqja') . '&faqja=' . $next . '">Prapa</a></li>';
		} else {
			echo '<li class="previous-off">Prapa</li>';
		}
		
		for ($i = 1; $i <= $total_pages; $i++) {
			$active = '';
			if ($i == $this->page) $active = 'class="active"';
			echo '<li><a href="admin.php?' . $url->qs('faqja') . '&faqja=' . $i . '" ' . $active . '>' . $i . '</a></li>';
		}
		
		if ($this->page < $total_pages) {
			$prev = $this->page + 1;
			echo '<li class="next"><a href="admin.php?' . $url->qs('faqja') . '&faqja=' . $prev . '">Para</a></li>';
		} else {
			echo '<li class="next-off">Para</li>';
		}
		
		echo '</ul>';
		echo '</div>';
	}

}