<?php
class Pages extends Loader {

	public function home () {
		$results = $this->db->query("SELECT title_$this->lang, content_$this->lang FROM pages WHERE homepage=1 LIMIT 1");
		
		if (!$results->num_rows()) return false;
		
		$rows = $results->single_result();
		
		return array('title'=>stripslashes($rows["title_$this->lang"]), 'content'=>stripslashes($rows["content_$this->lang"]));
	}
	
	public function show () {
		$id = (int) $_GET['page_id'];
		
		$results = $this->db->query("SELECT title_$this->lang, content_$this->lang FROM pages WHERE id=$id LIMIT 1");
		
		if (!$results->num_rows()) {
			header('LOCATION: ' . PATH);
			exit();
		}
		
		$rows = $results->single_result();

		$content = stripslashes($rows['content_'.$this->lang]);
		$content = str_replace(array('{{ PATH_LANG }}', '{{ PATH }}'), array(PATH.$this->lang.'/', PATH), $content);
		
		return array('title' => stripslashes($rows["title_$this->lang"]), 'content' => $content);
	}
	
	public function url_id ($id) {
		$id = (int) $id;
		
		$results = $this->db->query("SELECT title_$this->lang FROM pages WHERE id=$id LIMIT 1");
		if ($results->num_rows()) {
			$values = $results->single_result();
			$title = $this->url->seo($values["title_$this->lang"]) . '/';
		}
		
		return PATH . $this->lang . '/' . $id . '/' . $title;
	}
	
	public function url_title ($id) {
		$id = (int) $id;
		
		$results = $this->db->query("SELECT title_$this->lang FROM pages WHERE id=$id LIMIT 1");
		if ($results->num_rows()) {
			$values = $results->single_result();
			return stripslashes($values["title_$this->lang"]);
		}
	}

}