<?php
include('config.php');
include('core/error.php');

set_error_handler('ErrorHandler');

include('core/loader.php');
include('core/db.php');
include('core/forms.php');
include('core/calendar.php');
include('core/url.php');
include('core/pagination.php');
include('core/fpagination.php');

$db = new DB;
$cal = new Calendar;
$forms = new Forms;
$url = new URL;
$pagination = new Pagination;
$fpagination = new fPagination;

$is_admin = false;
$site_url = $_SERVER['PHP_SELF'];

if (strstr($site_url, '/admin')) $is_admin = true;

function __autoload($class) {
	if ($is_admin) {
		$file = 'admin/classes/' . strtolower($class) . '.php';
	} else {
		$file = 'classes/' . strtolower($class) . '.php';
	}
	if (file_exists($file)) {
    	require_once($file);
    }
}

if ($is_admin) {
	$user = new User;
	$pages = new Pages;
	$news = new News;
} else {
	$lang = new Lang;
	$pages = new Pages;
	$news = new News;
}