<?php



/*



Plugin Name: WP Mobilize



Plugin URI: http://wpmobilize.com/



Description: With WP Mobilize you can create professional mobile websites using drag and drop technology! Get your first mobile site setup in minutes!



Version: 1.0.0



Author: WP Mobilize



Author URI: http://wpmobilize.com/







Copyright 2014 WP Mobilize







*/









/* <--- CREDITS ---->



*



* Social Badges Set 2 - http://simekonelove.deviantart.com/art/Neon-Social-Media-Buttons-174489616



* Social Badges Set 3 - http://arbent.net/blog/social-media-circles-icon-set



* Social Badges Set 5 - http://www.instantshift.com/2010/12/07/socialshift-icon-set-246-free-social-networking-icons/



*



*



*/







































//GLOBALS







$plugin_folder_name = dirname(plugin_basename(__FILE__));











//Let's add a page to the Wordpress menu for some instructions



function mobile_appy_admin() {



	include('admin/wpmobilize_admin.php');



}



function mobile_appy_register_menu_settings() {



	add_submenu_page( 'edit.php?post_type=mobile', 'WP Mobilize Info', 'Documentation', 'activate_plugins', 'wpmobilize-settings', 'mobile_appy_admin');



}



add_action('admin_menu', 'mobile_appy_register_menu_settings');











//create a custom post type called 'wordpresent'



add_action( 'init', 'mobile_appy_init' );



function mobile_appy_init() {



    register_post_type('mobile', array('label' => 'Mobile Sites','description' => '','public' => true,'show_ui' => true,'show_in_menu' => true,'capability_type' => 'page','hierarchical' => false,'query_var' => true,'exclude_from_search' => false,'supports' => array('title','revisions',),'labels' => array('name' => 'Mobile Sites',



    'singular_name' => 'Mobile Site',



    'menu_name' => 'Mobile Sites',



    'add_new' => 'Add New',



    'add_new_item' => 'Add New Mobile Site',



    'edit' => 'Edit',



    'edit_item' => 'Edit Mobile Site',



    'new_item' => 'New Mobile Site',



    'view' => 'View Mobile Site',



    'view_item' => 'View Mobile Site',



    'search_items' => 'Search Mobile Sites',



    'not_found' => 'No Mobile Sites Found',



    'not_found_in_trash' => 'No Mobile Site found in trash',



    'parent' => 'Parent Mobile Site',



    ),) );



}











//add flush rewrite rules on plugin activation



function mobile_appy_rewrite_flush() {



    // First, we "add" the custom post type via the above written function.



    // Note: "add" is written with quotes, as CPTs don't get added to the DB,



    // They are only referenced in the post_type column with a post entry, 



    // when you add a post of this CPT.



    mobile_appy_init();







    // ATTENTION: This is *only* done during plugin activation hook in this example!



    // You should *NEVER EVER* do this on every page load!!



    flush_rewrite_rules();



}



register_activation_hook( __FILE__, 'mobile_appy_rewrite_flush' );















//This will add a single template to be used with the wpresents CPT



function mobile_appy_template() {



	global $post;



	global $plugin_folder_name;



	if ($post->post_type == 'mobile') {



     include (dirname( __FILE__ ) . '/includes/mobile-template.php');



     exit;



	 }



}



 



add_action('template_redirect', 'mobile_appy_template');











//remove meta boxes from mobile site edit screen



add_action('admin_head', 'mobile_appy_remove_boxes');



function mobile_appy_remove_boxes() {



	remove_meta_box('slugdiv', 'mobile', 'normal');



}















function mobile_appy_custom_admin_scripts() {



	



	//main js file - also enques jquery, jquery ui and jquery plugin scripts



	wp_enqueue_script( 'mobile-appy-script', plugins_url('js/mobile_appy.js', __FILE__), array ('jquery', 'jquery-ui-core', 'jquery-ui-tabs', 'jquery-ui-accordion', 'jquery-ui-sortable', 'jquery-ui-draggable', 'jquery-ui-droppable', 'jquery-ui-button', 'jquery-ui-dialog', 'jquery-ui-slider') );







	//main css



	wp_register_style( 'mobile-appy-style', plugins_url('css/mobile-appy-style.css', __FILE__) );



	wp_enqueue_style( 'mobile-appy-style');



	



	//jquery ui style



	wp_register_style( 'mobile-appy-ui-style', "http://code.jquery.com/ui/1.10.2/themes/smoothness/jquery-ui.css" );



	wp_enqueue_style( 'mobile-appy-ui-style');



	



	//Spectrum Color Picker JS file



	wp_enqueue_script( 'mobile-appy-spectrum', plugins_url('js/spectrum.js', __FILE__));



	



	//Spectrum Color Picker CSS file



	wp_register_style( 'mobile-appy-spectrum-style', plugins_url('css/spectrum-style.css', __FILE__));



	wp_enqueue_style( 'mobile-appy-spectrum-style');



	



	//Slim Scroll JS file



	wp_enqueue_script( 'mobile-appy-slim-scroll', plugins_url('js/slim-scroll.js', __FILE__));







	//jQuery Easing plugin



	wp_enqueue_script( 'mobile-appy-easing', plugins_url('js/easing-plugin.js', __FILE__));







	//style for JQMobi SVG fonts



	wp_register_style( 'appy_svg_icons', plugins_url('includes/css/icons.css', __FILE__) );



	wp_enqueue_style( 'appy_svg_icons');



	



	//new media uploader and custom upload script



	wp_enqueue_media();



	wp_enqueue_script('mobile-appy-tap-uploader', plugins_url('js/tap-uploader.js', __FILE__));



	



	



	



}



add_action( 'admin_enqueue_scripts', 'mobile_appy_custom_admin_scripts' );



















// Add the Meta Box



function mobile_appy_custom_meta_box() {



    add_meta_box(



		'mobile_appy_meta_box', // $id



		'Your Mobile Site', // $title 



		'mobile_appy_show_meta_box', // $callback



		'mobile', // $page



		'normal', // $context



		'high'); // $priority



}



add_action('add_meta_boxes', 'mobile_appy_custom_meta_box');











function mobile_appy_show_meta_box() {



	global $post;?>







	<?php wp_nonce_field( basename( __FILE__ ), 'mobile_appy_save_nonce' ); 



	



	//get all meta data



	$appyValues = get_post_custom($post->ID);



	//print_r($appyValues);







	



	$noPages = array();



	foreach ($appyValues as $metaValue => $data) {



		if (strpos($metaValue, 'appy_options_page_title_') !== FALSE) {



			$metaValue = str_replace('appy_options_page_title_', '', $metaValue);



			$noPages[] = $metaValue;



		}



	}



	



	?>



	



	



<div id="holder" class="inside-appy">







	<div id="add-a-page-holder" >



		<div id="add-a-page">Add Page</div>



		



			<div id="page-info">



				Currently on page <span id="current-page"><?php echo $noPages[0];?></span></p>



			Jump to page



				<select id="page-selection">



					<?php



					



					



					



					



					foreach ($noPages as $data => $currPage) {



						$isPages++;



						echo "<option value='".$currPage."'>".$currPage."</option>";



					}



					if ($isPages == 0) {



						echo "<option value='1'>1</option>";



					}



					?>



				</select>



			</div>



			<div id="delete-current-page">Delete Page</div>



			<input type="hidden" id="total-page-count" name="appy-options-total-page-count" value='<?php (isset($appyValues['appy_options_total_page_count'][0]) ? print $appyValues['appy_options_total_page_count'][0] : print "1"); ?>'/>



	</div>



	<br style='clear:both;'>



    <div id="left-settings-accordion">



        	<h4 id="site-settings-header-block">Site Settings</h4>







        <div>



            <div id="site-settings-options-area">



                <ul>



                    <li>	<a href="#menu-tab">Site Menus</a>







                    </li>



                    <li>	<a href="#theme-tab">Theme</a>







                    </li>



                </ul>



                <div id="menu-tab">



                    <label for="use-header-option-sitewide">



                        <label for="site-menu-option">Use a navigational menu?</label>



                        <br>



                        <select name="appy-options-site-menu-option" id="site-menu-option">



                            <option value="no" <?php if ($appyValues['appy_options_site_menu_option'][0] == 'no') {print "selected";}?>>No</option>



                            <option value="yes"<?php if (!isset($appyValues['appy_options_site_menu_option'][0])||($appyValues['appy_options_site_menu_option'][0] == 'yes')) {print "selected";}?>>Yes</option>



                        </select>



                        <br>



                    </label>



                    <div id="site-menu-icon-option-holder">



                        <label for="site-menu-icon-option">Menu Type</label>



                        <br>



                        <select name="appy-options-site-menu-icon-option" id="site-menu-icon-option">



                            <option value="icons-text" <?php if ($appyValues['appy_options_site_menu_icon_option'][0] == 'icons-text'){print "selected";}?>>Icons and Text</option>



                            <option value="icons" <?php if ($appyValues['appy_options_site_menu_icon_option'][0] == 'icons'){print "selected";}?>>Just Icons</option>



                            <option value="text" <?php if ($appyValues['appy_options_site_menu_icon_option'][0] == 'text'){print "selected";}?>>Just Text</option>



                        </select>



                    </div>



                </div>



                <div id="theme-tab">



				<h4>Heading</h4>



					<label for="site-option-heading-background-color">Heading Background Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-heading-background-color" id="site-option-heading-background-color" type='text'>



                    <br />



					<label for="site-option-heading-text-color">Heading Text Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-heading-text-color" id="site-option-heading-text-color" type='text'>



                    <br />



					<label for="site-option-heading-size">Heading Size</label>



                    <select name="appy-options-site-option-heading-size" id="site-option-heading-size">



                        <option value="10px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '10px'){print "selected";}?>>10px</option>



                        <option value="11px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '11px'){print "selected";}?>>11px</option>



                        <option value="12px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '12px'){print "selected";}?>>12px</option>



                        <option value="13px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '13px'){print "selected";}?>>13px</option>



                        <option value="14px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '14px'){print "selected";}?>>14px</option>



                        <option value="15px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '15px'){print "selected";}?>>15px</option>



                        <option value="16px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '16px'){print "selected";}?>>16px</option>



                        <option value="17px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '17px'){print "selected";}?>>17px</option>



                        <option value="18px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '18px'){print "selected";}?>>18px</option>



                        <option value="19px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '19px'){print "selected";}?>>19px</option>



                        <option value="20px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '20px'){print "selected";}?>>20px</option>



                        <option value="21px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '21px'){print "selected";}?>>21px</option>



                        <option value="22px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '22px'){print "selected";}?>>22px</option>



                        <option value="23px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '23px'){print "selected";}?>>23px</option>



                        <option value="24px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '24px'){print "selected";}?>>24px</option>



                        <option value="25px" <?php if (empty($appyValues['appy_options_site_option_heading_size'][0])) {print "selected";} if ($appyValues['appy_options_site_option_heading_size'][0] == '25px'){print "selected";}?>>25px</option>



                        <option value="26px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '26px'){print "selected";}?>>26px</option>



                        <option value="27px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '27px'){print "selected";}?>>27px</option>



                        <option value="28px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '28px'){print "selected";}?>>28px</option>



                        <option value="29px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '29px'){print "selected";}?>>29px</option>



                        <option value="30px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '30px'){print "selected";}?>>30px</option>



                        <option value="31px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '31px'){print "selected";}?>>31px</option>



                        <option value="32px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '32px'){print "selected";}?>>32px</option>



                        <option value="33px"<?php if ($appyValues['appy_options_site_option_heading_size'][0] == '33px'){print "selected";}?>>33px</option>



                        <option value="34px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '34px'){print "selected";}?>>34px</option>



                        <option value="35px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '35px'){print "selected";}?>>35px</option>



                        <option value="36px" <?php if ($appyValues['appy_options_site_option_heading_size'][0] == '36px'){print "selected";}?>>36px</option>



                    </select>



                    <br />



					<label for="site-option-heading-font">Heading Font</label>



                    <select name="appy-options-site-option-heading-font" id="site-option-heading-font">



                        <option value="Arial, Helvetica, sans-serif" <?php if (empty($appyValues['appy_options_site_option_heading_font'][0])) {print "selected";} if ($appyValues['appy_options_site_option_heading_font'][0] == 'Arial, Helvetica, sans-serif'){print "selected";}?>>Arial, Helvetica, sans-serif</option>



                        <option value="Arial Black, Gadget, Arial, Helvetica, sans-serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Arial Black, Gadget, Arial, Helvetica, sans-serif'){print "selected";}?>>Arial Black, Gadget, Arial, Helvetica, sans-serif</option>



                        <option value="Impact, Charcoal, Arial, Helvetica, sans-serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Impact, Charcoal, Arial, Helvetica, sans-serif'){print "selected";}?>>Impact, Charcoal, Arial, Helvetica, sans-serif</option>



                        <option value="Lucida Sans Unicode, Lucida Grande, Arial, Helvetica, sans-serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Lucida Sans Unicode, Lucida Grande, Arial, Helvetica, sans-serif'){print "selected";}?>>Lucida Sans Unicode, Lucida Grande, Arial, Helvetica, sans-serif</option>



                        <option value="Tahoma, Geneva, Arial, Helvetica, sans-serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Tahoma, Geneva, Arial, Helvetica, sans-serif'){print "selected";}?>>Tahoma, Geneva, Arial, Helvetica, sans-serif</option>



                        <option value="Trebuchet MS, Trebuchet, sans-serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Trebuchet MS, Trebuchet, sans-serif'){print "selected";}?>>Trebuchet MS, Trebuchet, sans-serif</option>



                        <option value="Verdana, Geneva, sans-serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Verdana, Geneva, sans-serif'){print "selected";}?>>Verdana, Geneva, sans-serif</option>



                        <option value="Georgia, Times New Roman, Times, serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Georgia, Times New Roman, Times, serif'){print "selected";}?>>Georgia, Times New Roman, Times, serif</option>



                        <option value="Palatino Linotype, Book Antiqua, Palatino, serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Palatino Linotype, Book Antiqua, Palatino, serif'){print "selected";}?>>Palatino Linotype, Book Antiqua, Palatino, serif</option>



                        <option value="Times New Roman, Times, serif" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Times New Roman, Times, serif'){print "selected";}?>>Times New Roman, Times, serif</option>



                        <option value="Courier New, Courier, monospace" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Courier New, Courier, monospace'){print "selected";}?>>Courier New, Courier, monospace</option>



                        <option value="Lucida Console, Monaco, monospace" <?php if ($appyValues['appy_options_site_option_heading_font'][0] == 'Lucida Console, Monaco, monospace'){print "selected";}?>>Lucida Console, Monaco, monospace</option>



                    </select>



                    <br />



					<h4>Page</h4>



                    <label for="site-option-background-color">Page Background Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-background-color" id="site-option-background-color" type='text'>



                    <br />                    



					<label for="site-option-body-font">Body Font</label>



                    <select name="appy-options-site-option-body-font" id="site-option-body-font">



                        <option value="Arial, Helvetica, sans-serif" <?php if (empty($appyValues['appy_options_site_option_body_font'][0])) {print "selected";} if ($appyValues['appy_options_site_option_body_font'][0] == 'Arial, Helvetica, sans-serif'){print "selected";}?>>Arial, Helvetica, sans-serif</option>



                        <option value="Arial Black, Gadget, Arial, Helvetica, sans-serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Arial Black, Gadget, Arial, Helvetica, sans-serif'){print "selected";}?>>Arial Black, Gadget, Arial, Helvetica, sans-serif</option>



                        <option value="Impact, Charcoal, Arial, Helvetica, sans-serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Impact, Charcoal, Arial, Helvetica, sans-serif'){print "selected";}?>>Impact, Charcoal, Arial, Helvetica, sans-serif</option>



                        <option value="Lucida Sans Unicode, Lucida Grande, Arial, Helvetica, sans-serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Lucida Sans Unicode, Lucida Grande, Arial, Helvetica, sans-serif'){print "selected";}?>>Lucida Sans Unicode, Lucida Grande, Arial, Helvetica, sans-serif</option>



                        <option value="Tahoma, Geneva, Arial, Helvetica, sans-serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Tahoma, Geneva, Arial, Helvetica, sans-serif'){print "selected";}?>>Tahoma, Geneva, Arial, Helvetica, sans-serif</option>



                        <option value="Trebuchet MS, Trebuchet, sans-serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Trebuchet MS, Trebuchet, sans-serif'){print "selected";}?>>Trebuchet MS, Trebuchet, sans-serif</option>



                        <option value="Verdana, Geneva, sans-serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Verdana, Geneva, sans-serif'){print "selected";}?>>Verdana, Geneva, sans-serif</option>



                        <option value="Georgia, Times New Roman, Times, serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Georgia, Times New Roman, Times, serif'){print "selected";}?>>Georgia, Times New Roman, Times, serif</option>



                        <option value="Palatino Linotype, Book Antiqua, Palatino, serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Palatino Linotype, Book Antiqua, Palatino, serif'){print "selected";}?>>Palatino Linotype, Book Antiqua, Palatino, serif</option>



                        <option value="Times New Roman, Times, serif" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Times New Roman, Times, serif'){print "selected";}?>>Times New Roman, Times, serif</option>



                        <option value="Courier New, Courier, monospace" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Courier New, Courier, monospace'){print "selected";}?>>Courier New, Courier, monospace</option>



                        <option value="Lucida Console, Monaco, monospace" <?php if ($appyValues['appy_options_site_option_body_font'][0] == 'Lucida Console, Monaco, monospace'){print "selected";}?>>Lucida Console, Monaco, monospace</option>



                    </select>



					<h4>Bottom Menu</h4>



					<label for="site-option-bottom-menu-background-color">Bottom Menu Background Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-bottom-menu-background-color" id="site-option-bottom-menu-background-color" type='text'>



					<br />



					<label for="site-option-bottom-menu-text-color">Bottom Menu Text Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-bottom-menu-text-color" id="site-option-bottom-menu-text-color" type='text'>



                    <br />



					<h4>Lists</h4>



                    <label for="site-option-list-background-color">List Background Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-list-background-color" id="site-option-list-background-color" type='text'>



                    <br />



                    <label for="site-option-list-item-color">List Item Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-list-item-color" id="site-option-list-item-color" type='text'>



                    <br />



					<br />



					<label for="site-option-list-item-size">List Item Size</label>



                    <select name="appy-options-site-option-list-item-size" id="site-option-list-item-size">



                        <option value="10px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '10px'){print "selected";}?>>10px</option>



                        <option value="11px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '11px'){print "selected";}?>>11px</option>



                        <option value="12px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '12px'){print "selected";}?>>12px</option>



                        <option value="13px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '13px'){print "selected";}?>>13px</option>



                        <option value="14px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '14px'){print "selected";}?>>14px</option>



                        <option value="15px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '15px'){print "selected";}?>>15px</option>



                        <option value="16px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '16px'){print "selected";}?>>16px</option>



                        <option value="17px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '17px'){print "selected";}?>>17px</option>



                        <option value="18px" <?php if (empty($appyValues['appy_options_site_option_list_item_size'][0])) {print "selected";} if ($appyValues['appy_options_site_option_list_item_size'][0] == '18px'){print "selected";}?>>18px</option>



                        <option value="19px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '19px'){print "selected";}?>>19px</option>



                        <option value="20px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '20px'){print "selected";}?>>20px</option>



                        <option value="21px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '21px'){print "selected";}?>>21px</option>



                        <option value="22px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '22px'){print "selected";}?>>22px</option>



                        <option value="23px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '23px'){print "selected";}?>>23px</option>



                        <option value="24px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '24px'){print "selected";}?>>24px</option>



                        <option value="25px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '25px'){print "selected";}?>>25px</option>



                        <option value="26px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '26px'){print "selected";}?>>26px</option>



                        <option value="27px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '27px'){print "selected";}?>>27px</option>



                        <option value="28px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '28px'){print "selected";}?>>28px</option>



                        <option value="29px" <?php if ($appyValues['appy_options_site_option_list_item_size'][0] == '29px'){print "selected";}?>>29px</option>



                    </select>



                    <br />



					<h4>Buttons</h4>



                    <label for="site-option-button-color">Button Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-button-color" id="site-option-button-color" type='text'><br />



					<label for="site-option-button-text-color">Button Text Color</label>



                    <input class="pick-a-color" name="appy-options-site-option-button-text-color" id="site-option-button-text-color" type="text">



					<script>



						jQuery(document).ready(function() {



							jQuery("#site-option-background-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_background_color'][0]) ? print $appyValues['appy_options_site_option_background_color'][0] : print '#FFFFFF');?>");



							jQuery("#site-option-body-text-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_body_text_color'][0]) ? print $appyValues['appy_options_site_option_body_text_color'][0] : print '#555555');?>");



							jQuery("#site-option-heading-text-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_heading_text_color'][0]) ? print $appyValues['appy_options_site_option_heading_text_color'][0] : print '#FFFFFF');?>");



							jQuery("#site-option-heading-background-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_heading_background_color'][0]) ? print $appyValues['appy_options_site_option_heading_background_color'][0] : print '#0088D1');?>");



							jQuery("#site-option-bottom-menu-background-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_bottom_menu_background_color'][0]) ? print $appyValues['appy_options_site_option_bottom_menu_background_color'][0] : print '#0088D1');?>");



							jQuery("#site-option-bottom-menu-text-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_bottom_menu_text_color'][0]) ? print $appyValues['appy_options_site_option_bottom_menu_text_color'][0] : print '#FFFFFF');?>");



							jQuery("#site-option-side-menu-background-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_side_menu_background_color'][0]) ? print $appyValues['appy_options_site_option_side_menu_background_color'][0] : print '#00AEEF');?>");



							jQuery("#site-option-side-menu-text-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_side_menu_text_color'][0]) ? print $appyValues['appy_options_site_option_side_menu_text_color'][0] : print '#FFFFFF');?>");



							jQuery("#site-option-list-background-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_list_background_color'][0]) ? print $appyValues['appy_options_site_option_list_background_color'][0] : print '#FFFFFF');?>");



							jQuery("#site-option-list-item-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_list_item_color'][0]) ? print $appyValues['appy_options_site_option_list_item_color'][0] : print '#555555');?>");



							jQuery("#site-option-button-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_button_color'][0]) ? print $appyValues['appy_options_site_option_button_color'][0] : print '#D6E0DB');?>");



							jQuery("#site-option-button-text-color").spectrum("set", "<?php (isset($appyValues['appy_options_site_option_button_text_color'][0]) ? print $appyValues['appy_options_site_option_button_text_color'][0] : print '#000000');?>");



						});



					</script>



                </div>



            </div>



        </div>



        	<h4>Page Settings</h4>







        <div>



            <div id="page-settings-area-holder">



		



		<?php



		$thisPage = 0;



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_page_title_') !== FALSE) { //narrow down to only text content areas



					$onePage = 1;



					$thisPage++;



				$currPage = str_replace('appy_options_page_title_', '', $metaTitle);



				$currTitle = "appy_options_page_title_".$currPage;



				$currIcon = "appy_options_page_option_menu_icon_".$currPage;



				$currInclude = "appy_options_page_option_include_in_menu_".$currPage;



				



				



		?>



		



		<div <?php if ($thisPage !== 1) echo "style='display:none;'";?> id='page-<?php echo $currPage; ?>-settings-container' class='page-settings-container'>



			<label for='page-title-<?php echo $currPage; ?>'>Page Title</label><br />



			<input name='appy-options-page-title-<?php echo $currPage; ?>' id='page-title-<?php echo $currPage; ?>' value='<?php echo $appyValues[$currTitle][0]; ?>' class='page-title-option' type='text' /><br />



			<label for='page-option-include-in-menu-<?php echo $currPage; ?>'>Include page in menus?</label><br />



			<select name='appy-options-page-option-include-in-menu-<?php echo $currPage; ?>' class='page-in-menu-option' id='page-option-include-in-menu-<?php echo $currPage; ?>'>



				<option value='yes' <?php if ($appyValues[$currInclude][0] == 'yes'){print "selected";}?>>Yes</option>



				<option value='no' <?php if ($appyValues[$currInclude][0] == 'no'){print "selected";}?>>No</option>



			</select><br />



			<label for='page-option-menu-icon-<?php echo $currPage; ?>'>Menu Icon</label><br />



			<select name='appy-options-page-option-menu-icon-<?php echo $currPage; ?>' class='icon-in-menu-option' id='page-option-menu-icon-<?php echo $currPage; ?>'>



			



			<?php



			



			$iconOptions = array('home','pencil','picture','camera','headset','paper','stack','folder','tag','basket','phone','mail','location','clock','calendar','message','chat','user','loading','refresh','magnifier','key','settings','graph','trash','pin','target','download','upload','star','heart','warning','add','remove','question','info','error','check','minimize','close','up','down','left','right','tools','html5','css','js','cloud','tv','wifi','new','mic','database','busy','bug','lamp');



			



			foreach ($iconOptions as $key => $icon) {



			?>



				<option value='<?php echo $icon;?>' <?php if ($appyValues[$currIcon][0] == $icon){print "selected";}?>><?php echo $icon;?></option>



			<?php 



			}



			?>







			</select>



			



			<div id="icon-preview-<?php echo $currPage; ?>" class="page-icon-preview icon big <?php echo $appyValues[$currIcon][0]; ?>"></div>



		</div>



		



		<?php



			}



		}



	}



	



	if ($onePage !== 1) {



		?>



		<div id='page-1-settings-container' class='page-settings-container'>



			<label for='page-title-1'>Page Title</label><br />



			<input name='appy-options-page-title-1' id='page-title-1' value='<?php if (isset($appyValues['appy_options_page_title_1'][0])) {print $appyValues['appy_options_page_title_1'][0];} else {print "Page 1";}?>' class='page-title-option' type='text' /><br />



			<label for='page-option-include-in-menu-1'>Include page in menus?</label><br />



			<select name='appy-options-page-option-include-in-menu-1' class='page-in-menu-option' id='page-option-include-in-menu-1'>



				<option value='yes' <?php if ($appyValues['appy_options_page_options_inclue_in_menu_1'][0] == 'yes'){print "selected";}?>>Yes</option>



				<option value='no' <?php if ($appyValues['appy_options_page_options_inclue_in_menu_1'][0] == 'no'){print "selected";}?>>No</option>



			</select><br />



			<label for='page-option-menu-icon-1'>Menu Icon</label><br />



			<select name='appy-options-page-option-menu-icon-1' class='icon-in-menu-option' id='page-option-menu-icon-1'>



			



			<?php



			



			$iconOptions = array('home','pencil','picture','camera','headset','paper','stack','folder','tag','basket','phone','mail','location','clock','calendar','message','chat','user','loading','refresh','magnifier','key','settings','graph','trash','pin','target','download','upload','star','heart','warning','add','remove','question','info','error','check','minimize','close','up','down','left','right','tools','html5','css','js','cloud','tv','wifi','new','mic','database','busy','bug','lamp');



			



			foreach ($iconOptions as $key => $icon) {



			 echo "



				<option value='".$icon."'";







				if ($appyValues['appy_options_page_option_menu_icon_1'][0] === $icon) {



					print "selected='selected'";



				} else if ($icon == "home") {



				print "selected='selected'";



				} 



				echo ">".$icon."</option>";







			}



			?>







			</select>



			



			<div id="icon-preview-1" class="page-icon-preview icon big home"></div>



		</div>



		



		<?php



	};



	



	?>



			



            </div>



        </div>



        	<h4>Features</h4>







        <div>



            <div id="feature-list">



                <ul id="feature-listing"></ul>



            </div>



        </div>



    </div>



    <div id="phone-space">



        <div id="header-holder"></div>



        <div id="side-menu-activate-holder">Menu</div>



        <div id="side-menu-holder">



            <div id="side-menu-actual">



                <div id="side-menu-inner">



                    <div id="close-side-menu">X</div>



                    <ul>



                        <li class='side-menu-item icon home' id='page-1-side-menu'><a>Page 1</a>







                        </li>



                    </ul>



                </div>



            </div>



        </div>



        <div id="smart-screen" style="background-color: <?php print $appyValues['appy_options_site_option_background_color'][0]?>">



            <div id="smart-screen-visible">



                



					



					<?php



					



					if ($appyValues['appy_options_total_page_count'][0] == 0) {



						$appyValues['appy_options_total_page_count'][0] = 1;



					}



					



$noPages = array_fill(1, $appyValues['appy_options_total_page_count'][0], '');











foreach ($noPages as $currPage => $data) {



	//create some variables for infor to be called



	$currContentOrder = "appy_options_screen_page_".$currPage."_order";



	$currContentOrder = $appyValues[$currContentOrder][0];



	$currContentOrder = explode(',', $currContentOrder);



	$currHeader = "appy_options_header_content_page_".$currPage;



	



	$hiddenCheck = "appy_options_screen_page_".$currPage."_order_hidden";



	



		if (isset($appyValues[$hiddenCheck][0])) {



			echo "



				<div class='screen-page hidden-page' style='height:0px;' id='screen-page-".$currPage."' >



                    <ul class='screen-list'>";



		} else {



			echo "



				<div class='screen-page' id='screen-page-".$currPage."' >



                    <ul class='screen-list'>";



		}



	



	



	foreach ($currContentOrder as $order => $metaTitle) {



			$metaTitle = str_replace('-','_', $metaTitle);



			



	











				if (strpos($metaTitle,'screen_header') !== FALSE) { //narrow down to only text content areas



					//create variables with meta values to be called



					$headerCount = str_replace("screen_header_", "", $metaTitle);



					$currBack = "appy_options_site_option_heading_background_color";



					$currColor = "appy_options_site_option_heading_text_color";



					$currSize = "appy_options_site_option_heading_size";



					$currFont = "appy_options_site_option_heading_font";



					$currContent = "appy_options_header_content_" . $headerCount;



					



					//replace underscores with hyphens



					$headerCount = str_replace('_', '-', $headerCount);



					echo "



					<li id='screen-header-".$headerCount."' class='option-Header ui-draggable screen-header on-screen-feature' style='display: list-item; background-color:".$appyValues[$currBack][0].";'><h1 style='color:".$appyValues[$currColor][0].";font-size:".$appyValues[$currSize][0].";font-family:".$appyValues[$currFont][0].";'>".$appyValues[$currContent][0]."</h1></li>";



					







				}











				if (strpos($metaTitle,'screen_text') !== FALSE) { //narrow down to only text content areas



					//create variables with meta values to be called



					$textCount = str_replace('screen_text_', '', $metaTitle);



					$currContent = "appy_options_text_content_" . $textCount;



					$currSize = "appy_options_text_size_" . $textCount;



					$currColor = "appy_options_text_color_" . $textCount;



					$currAlign = "appy_options_text_alignment_" . $textCount;



					$currStyle = "appy_options_text_style_" . $textCount;



					$currLine = "appy_options_text_line_height_" . $textCount;



					



					//replace underscores with hyphens



					$textCount = str_replace('_', '-', $textCount);



					echo "



					



					<li id='screen-text-".$textCount."' class='option-Text ui-draggable screen-text on-screen-feature' style='display: list-item;color:".$appyValues[$currColor][0].";text-align:".$appyValues[$currAlign][0].";";



					



					if ($appyValues[$currStyle][0] == 'bold') { echo "font-weight:700;";}



					if ($appyValues[$currStyle][0] == 'italic') { echo "font-style:italic;";}



					if ($appyValues[$currStyle][0] == 'bold-italic') { echo "font-style:italic;font-weight:bold;";}



					echo "



					'><div class='outside-screen-text'><div class='inside-screen-text' style='font-size:".$appyValues[$currSize][0]."px;line-height:".$appyValues[$currLine][0]."'>



						".nl2br($appyValues[$currContent][0])."



					</div></div>



					</li>";



				}



				



				



				



				if (strpos($metaTitle,'screen_image') !== FALSE) { //narrow down to only image



					//create variables with meta values to be called



					$imageCount = str_replace('screen_image_', '', $metaTitle);



					$currWidth = "appy_options_image_width_" . $imageCount;



					$currPaddingTop = "appy_options_image_padding_top_" . $imageCount;



					$currPaddingBottom = "appy_options_image_padding_bottom_" . $imageCount;



					$currBorder = "appy_options_image_border_radius_" . $imageCount;



					$currShadow = "appy_options_image_shadow_" . $imageCount;



					$currImage = "appy_options_image_src_" . $imageCount;







					



					//replace underscores with hyphens



					$imageCount = str_replace('_', '-', $imageCount);



					echo "



					



					<li id='screen-image-".$imageCount."' class='option-Image ui-draggable screen-image on-screen-feature' style='display: list-item;padding-top:".$appyValues[$currPaddingTop][0]."px;padding-bottom:".$appyValues[$currPaddingBottom][0]."px;'><img style='width:".$appyValues[$currWidth][0]."%;border-radius:".$appyValues[$currBorder][0]."px;";



						if ($appyValues[$currShadow][0] == 'yes') {



							print "box-shadow: 0px 2px 4px rgba(81,81,81,.7);";



						}



					echo "'class='on-screen-image' src='".$appyValues[$currImage][0]."'></img></li>";



				}







		



		







				if (strpos($metaTitle,'screen_divider') !== FALSE) { //narrow down to only text content areas



					//create variables with meta values to be called



					$dividerCount = str_replace('screen_divider_', '', $metaTitle);



					$currPaddingTop = "appy_options_divider_padding_top_" . $dividerCount;



					$currPaddingBottom = "appy_options_divider_padding_bottom_" . $dividerCount;



					$currHeight = "appy_options_divider_height_" . $dividerCount;



					$currWidth = "appy_options_divider_width_" . $dividerCount;



					$currCorner = "appy_options_divider_border_radius_" . $dividerCount;



					$currColor = "appy_options_divider_color_" . $dividerCount;



					



					//replace underscores with hyphens



					$dividerCount = str_replace('_', '-', $dividerCount);



					echo "



					



					<li id='screen-divider-".$dividerCount."' class='screen-divider on-screen-feature' style='display: list-item;padding-top:".$appyValues[$currPaddingTop][0]."px;padding-bottom:".$appyValues[$currPaddingBottom][0]."px;'>



					



						<div class='screen-divider-feature' style='height:".$appyValues[$currHeight][0]."px;width:".$appyValues[$currWidth][0]."%;border-radius:".$appyValues[$currCorner][0]."px;color:".$appyValues[$currColor][0]."'></div>



					



					</li>";



				}















				if (strpos($metaTitle,'screen_button') !== FALSE) { //narrow down to only text content areas



					//create variables with meta values to be called



					$buttonCount = str_replace('screen_button_', '', $metaTitle);



					$currText = "appy_options_button_text_" . $buttonCount;



					$currFontSize = "appy_options_button_font_size_" . $buttonCount;



					$currBorder = "appy_options_button_border_radius_" . $buttonCount;



					$currHeight = "appy_options_button_height_" . $buttonCount;



					$currWidth = "appy_options_button_width_" . $buttonCount;



					$thisBack = "appy_options_site_option_button_color";



					$thisTColor = "appy_options_site_option_button_text_color";



					$currIlink = "appy_options_button_options_internal_link_hidden_" . $buttonCount;



					$currElink = "appy_options_button_options_external_link" . $buttonCount;



					$currLinkType = "appy_options_button_options_link_type" . $buttonCount;



					



					//replace underscores with hyphens



					$buttonCount = str_replace('_', '-', $buttonCount);



					echo "



					



					



					



					<li id='screen-button-".$buttonCount."' class='screen-button on-screen-feature' style='display: list-item;'><div class='screen-button-feature' style='background-color:".$appyValues[$thisBack][0].";color:".$appyValues[$thisTColor][0].";width:".$appyValues[$currWidth][0]."%;height: ".$appyValues[$currHeight][0]."px; font-size: ".$appyValues[$currFontSize][0]."px; border-radius: ".$appyValues[$currBorder][0]."px;line-height:".$appyValues[$currHeight][0]."px;'>".nl2br($appyValues[$currText][0])."</div></li>";



				}







				if (strpos($metaTitle,'screen_tap_call') !== FALSE) { //narrow down to only text content areas



					//create variables with meta values to be called



					$tapCallCount = str_replace('screen_tap_call_', '', $metaTitle);



					$currText = "appy_options_tap_call_text_" . $tapCallCount;



					$currFontSize = "appy_options_tap_call_font_size_" . $tapCallCount;



					$currBorder = "appy_options_tap_call_border_radius_" . $tapCallCount;



					$currHeight = "appy_options_tap_call_height_" . $tapCallCount;



					$thisBack = "appy_options_site_option_button_color";



					$thisTColor = "appy_options_site_option_button_text_color";



					$currWidth = "appy_options_tap_call_width_" . $tapCallCount;



					$currNumber = "appy_options_tap_call_number_" . $tapCallCount;







					



					//replace underscores with hyphens



					$tapCallCount = str_replace('_', '-', $tapCallCount);



					echo "



					



					



					



					<li id='screen-tap-call-".$tapCallCount."' class='screen-tap-call on-screen-feature' style='display: list-item;'><div class='screen-tap-call-feature' style='background-color:".$appyValues[$thisBack][0].";color:".$appyValues[$thisTColor][0].";width:".$appyValues[$currWidth][0]."%;height: ".$appyValues[$currHeight][0]."px; font-size: ".$appyValues[$currFontSize][0]."px; border-radius: ".$appyValues[$currBorder][0]."px;line-height:".$appyValues[$currHeight][0]."px;'>".nl2br($appyValues[$currText][0])."</div></li>";



				}



				



				if (strpos($metaTitle,'screen_tap_email') !== FALSE) { //narrow down to only text content areas



					//create variables with meta values to be called



					$tapCallCount = str_replace('screen_tap_email_', '', $metaTitle);



					$currText = "appy_options_tap_email_text_" . $tapCallCount;



					$currFontSize = "appy_options_tap_email_font_size_" . $tapCallCount;



					$currBorder = "appy_options_tap_email_border_radius_" . $tapCallCount;



					$currHeight = "appy_options_tap_email_height_" . $tapCallCount;



					$currWidth = "appy_options_tap_email_width_" . $tapCallCount;



					$thisBack = "appy_options_site_option_button_color";



					$thisTColor = "appy_options_site_option_button_text_color";



					$currNumber = "appy_options_tap_email_number_" . $tapCallCount;







					



					//replace underscores with hyphens



					$tapCallCount = str_replace('_', '-', $tapCallCount);



					echo "



					



					



					



					<li id='screen-tap-email-".$tapCallCount."' class='screen-tap-email on-screen-feature' style='display: list-item;'><div class='screen-tap-email-feature' style=background-color:".$appyValues[$thisBack][0].";color:".$appyValues[$thisTColor][0].";width:".$appyValues[$currWidth][0]."%;height: ".$appyValues[$currHeight][0]."px; font-size: ".$appyValues[$currFontSize][0]."px; border-radius: ".$appyValues[$currBorder][0]."px;line-height:".$appyValues[$currHeight][0]."px;'>".nl2br($appyValues[$currText][0])."</div></li>";



				}



















				if (strpos($metaTitle,'screen_social') !== FALSE) { //narrow down to only social link padding top areas



					//create variables with meta values to be called



					global $plugin_folder_name;



					$socialCount = str_replace('screen_social_', '', $metaTitle);



					$currBadgeSet = "appy_options_badge_set_social_".$socialCount;



					$path = plugins_url();



					$path = ''.$path.'/'.$plugin_folder_name.'';



					$ipath = ''.$path.'/includes';



					











					



					//replace underscores with hyphens



					$socialCount = str_replace('_', '-', $socialCount);



					











					







					



					echo"



					



					<li id='screen-social-".$socialCount."' class='screen-social on-screen-feature' style='display: list-item;'>



						<ul>



							<li class='social-screen-message' style='display: none;'><span class='social-screen-warning'>Use the menu on the right to add social links to this area</span></li>";



							



						foreach ($appyValues as $socialCheck => $data) {



							if (strpos($socialCheck, 'appy_options_social_options_') !== FALSE) {



							if (strpos($socialCheck, 'linkurl') !== FALSE) {



								$socialCountunder = str_replace("-", "_", $socialCount);



								$currSite = str_replace("appy_options_social_options_".$socialCountunder."_", "", $socialCheck);



								$currSite = str_replace("_linkurl", "", $currSite);



								



							echo "



							<li id='screen-social-".$socialCount."-".$currSite."' class='screen-social-badge' style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/".$currSite.".png);'></li>";



							



							}



							}



							



						}



						echo "	



						</ul>



					</li>";







				}











		







// create lists that have already been placed











		if (strpos($metaTitle,'screen_list_feature') !== FALSE) { //narrow down to only list areas



		



			//create variables with meta values to be called



			$listCountandPageUnder = str_replace('screen_list_feature_', '', $metaTitle);



			$listCountandPage = str_replace('_', '-', $listCountandPageUnder);



			



			echo "



			<li id='screen-list-feature-".$listCountandPage."' class='option-List ui-draggable screen-list-feature on-screen-feature' style='display: list-item;'>



			<ul id='screen-list-feature-list-".$listCountandPage."'>



			



			";



			



			foreach ($appyValues as $currListItem => $currItemData) {



				$currListFeature = "appy_options_list_repeatable_list_" .  $listCountandPageUnder . "_item_";



				if (strpos($currListItem,$currListFeature) !== FALSE) {



				if (strpos($currListItem,'_option_') == FALSE) {



					$thisName = str_replace('_','-',$currListItem);



					$thisName = str_replace('-title','',$thisName);



					$thisNameID = str_replace('appy-options-','',$thisName);



					$thisNameID = str_replace('-title','',$thisNameID);



					



					//create variables for each option to be checked



					$optionBase = str_replace('_title', '', $currListItem);



					$optionBaseunder = str_replace('appy_options_', '', $optionBase);



					$optionBase = str_replace('_', '-', $optionBaseunder);



					$optionBase = str_replace('list-repeatable-list-', 'screen-list-feature-list-', $optionBase);



					$listOptionType = $optionBase."_option_link_type";



					$listOptionExternal = $optionBase."_option_external_link";



					$listOptionTitle = "appy_options_".$optionBaseunder."_title";







					echo "



						<li style='background-color:".$appyValues['appy_options_site_option_list_background_color'][0].";color:".$appyValues['appy_options_site_option_list_item_color'][0]."' id='".$optionBase."'><a style='font-size:".$appyValues['appy_options_site_option_list_item_size'][0]."' class='inside-list-item' id='inside-list-".$optionBase."'>".$appyValues[$listOptionTitle][0]."</a></li>



						";



					}



				}



			}



			



			



			echo "



			</ul>



			</li>";



			



			



		}











		



	}



	



	$currPageOrderValue = "appy_options_screen_page_".$currPage."_order";



	



	



	echo "



	



				</ul>



					<input type='hidden' id='screen-page-".$currPage."-order' name='appy-options-screen-page-".$currPage."-order' value='".$appyValues[$currPageOrderValue][0]."' />



                </div>



	



	



	";



	



}



		



		



		?>



			



					



					



					



            </div>



        </div>



        <div id="bottom-menu-holder" style='background-color:<?php echo $appyValues['appy_options_site_option_bottom_menu_background_color'][0]?>;<?php if ((!isset($appyValues['appy_options_site_menu_option'][0]))||($appyValues['appy_options_site_menu_option'][0] == 'yes')) {print "display:block";}?>;'>



			<div id="inside-bottom-menu">



				<?php 



					$arePages = 1;



					foreach ($appyValues as $pageTitle => $data) {



						if(strpos($pageTitle, 'appy_options_page_title_') !== FALSE) {



							$arePages++;



							$pageCount = str_replace('appy_options_page_title_', '', $pageTitle);



							$useIcons = "appy_options_site_menu_icon_option";



							$currIcon = "appy_options_page_option_menu_icon_".$pageCount;



							$currInclude = "appy_options_page_option_include_in_menu_".$pageCount;



							



							if ($appyValues[$currInclude][0] == 'no') {



								break;



							}







								if ($appyValues[$useIcons][0] == "icons-text") {



									echo "



										<div class='bottom-menu-item icon ".$appyValues[$currIcon][0]."' style='color:".$appyValues['appy_options_site_option_bottom_menu_text_color'][0].";margin-top:0px;font-size:12px;line-height:67px;' id='page-".$pageCount."-bottom-menu'><span>".$appyValues[$pageTitle][0]."</span></div>";



								} else if ($appyValues[$useIcons][0] == "icons") {



									echo "



										<div class='bottom-menu-item icon ".$appyValues[$currIcon][0]."' style='color:".$appyValues['appy_options_site_option_bottom_menu_text_color'][0].";margin-top:5px;' id='page-".$pageCount."-bottom-menu'></div>";



								} else if ($appyValues[$useIcons][0] == "text") {



									echo "



										<div class='bottom-menu-item' style='color:".$appyValues['appy_options_site_option_bottom_menu_text_color'][0].";margin-top:0px;font-size:14px;line-height:43px;' id='page-".$pageCount."-bottom-menu'><span>".$appyValues[$pageTitle][0]."</span></div>";



								}



						}



					} if (($arePages == 1) && ($appyValues['appy_options_page_option_include_in_menu_1'][0] !== 'no')) {



						



						



						echo "



								<div class='bottom-menu-item icon home' id='page-1-bottom-menu'><span>Page 1</span></div>";



						} else if (($arePages == 1) && ($appyValues[$useIcons][0] == "icons")) {



							echo "



								<div class='bottom-menu-item icon home' id='page-1-bottom-menu'></div>";



						} else if (($arePages == 1) && ($appyValues[$useIcons][0] == "text")) {



							echo "



								<div class='bottom-menu-item' id='page-1-bottom-menu'><span>Page 1</span></div>";



					}



					



					







				?>



			</div>



        </div>



    </div>



    <div id="settings-area">



		<span id="close-settings">X</span>



		<input type='hidden' name="appy-options-list-feature-count" value="<?php print $appyValues['appy_options_list_feature_count'][0];?>" id="list-feature-count" />



		



		<?php



		



		//first, reverse the $appyValues array, because it is saved in reverse order



		$appyValues = array_reverse($appyValues);



		



		// create text areas that have already been placed



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_text_content') !== FALSE) { //narrow down to only text content areas



					//create variables with meta values to be called



					$textCount = str_replace('appy_options_text_content_', '', $metaTitle);



					$currContent = "appy_options_text_content_" . $textCount;



					$currSize = "appy_options_text_size_" . $textCount;



					$currColor = "appy_options_text_color_" . $textCount;



					$currAlign = "appy_options_text_alignment_" . $textCount;



					$currStyle = "appy_options_text_style_" . $textCount;



					$currLine = "appy_options_text_line_height_" . $textCount;



					



					//replace underscores with hyphens



					$textCount = str_replace('_', '-', $textCount);



					



					



					echo "



					



					<div id='container-text-".$textCount."' class='feature-container text-container' style='display:none;'>



								<h4>Text Settings</h4>



								<label for='text-content-".$textCount."'>Text Content</label>



								<textarea name='appy-options-text-content-".$textCount."' class='text-content-area' id='text-content-".$textCount."'>".$appyValues[$currContent][0]."</textarea>



								<div class='settings-instructions'><em>You may include any HTML code like...</em><code>&#60;a href='LINK'&#62;Label&#60;/a&#62;</code><code>&#60;div style=''&#62;&#60;/div&#62;</code><code>&#60;img src='' /&#62;</code></div>



								<div class='hidden-options-toggle'>Toggle Options</div>



									<div class='hidden-options-area' id='options-text-".$textCount."' style='display:none;'>



									<label class='font-size' for='text-size-".$textCount."'>Text Size</label>



									<div class='slider-bar font-size'></div>



									<input name='appy-options-text-size-".$textCount."' id='text-size-".$textCount."' value='";



									if (!empty($appyValues[$currSize][0])){print $appyValues[$currSize][0];} else {print "12";}



									echo "'><br />



									<script>



									jQuery('.slider-bar.font-size').slider({



										animate: 'slow',



										min: 8,



										max: 50,



										step: 1,



										value: '";(!empty($appyValues[$currSize][0]) ? print $appyValues[$currSize][0] : print "12");



									echo "'



									});



									</script>



									<label for='text-color-".$textCount."'>Text Color</label>



									<input name='appy-options-text-color-".$textCount."' id='text-color-".$textCount."' value='".$appyValues[$currColor][0]."'/><br />



									<script>



									jQuery('#text-color-".$textCount."').spectrum({



										color:	'".$appyValues[$currColor][0]."',



										showInput: true,



										className: 'full-spectrum',



										showInitial: true,



										showPalette: true,



										maxPaletteSize: 10,



										preferredFormat: 'hex',



										showButtons: false,



										move: function (color) {



											jQuery('#screen-text-".$textCount."').css('color', color.toHexString());



										},



										change: function (color) {



											jQuery('#screen-text-".$textCount."').css('color', color.toHexString());



										}



									});



									</script>



									<label for='text-style-".$textCount."'>Text Alignment</label>



									<select name='appy-options-text-alignment-".$textCount."' class='text-alignment-select' id='text-alignment-".$textCount."'>";



									?>



										<option value='left' <?php if ($appyValues[$currAlign][0] == 'left'){print "selected";}?>>Left</option>



										<option value='center' <?php if ($appyValues[$currAlign][0] == 'center'){print "selected";}?>>Center</option>



										<option value='right' <?php if ($appyValues[$currAlign][0] == 'right'){print "selected";}?>>Right</option>



										<option value='justify' <?php if ($appyValues[$currAlign][0] == 'justify'){print "selected";}?>>Justify</option>



									<?php



									echo "



									</select><br />



									<label for='text-style-".$textCount."'>Font Style</label>



									<select class='text-style-selector' name='appy-options-text-style-".$textCount."' id='text-style-".$textCount."'>";



									?>



										<option value='normal' <?php if ($appyValues[$currStyle][0] == 'normal'){print "selected";}?>>Normal</option>



										<option value='bold' <?php if ($appyValues[$currStyle][0] == 'bold'){print "selected";}?>>Bold</option>



										<option value='italic' <?php if ($appyValues[$currStyle][0] == 'italic'){print "selected";}?>>Italic</option>



										<option value='bold-italic' <?php if ($appyValues[$currStyle][0] == 'bold-italic'){print "selected";}?>>Bold Italic</option>



									<?php



									echo "



									</select><br />



									<label for='text-line-height-".$textCount."'>Line Height</label>



									<select name='appy-options-text-line-height-".$textCount."' class='text-line-height' id='text-line-height-".$textCount."'>";



									var_dump($appyValues[$currLine][0]);



									?>



										<option value='85%' <?php if ($appyValues[$currLine][0] == '85%'){print "selected='selected'";}?>>Tight</option>



										<option value='100%' <?php if ($appyValues[$currLine][0] == '100%'){print "selected='selected'";}?>>Normal</option>



										<option value='125%' <?php if ($appyValues[$currLine][0] == '125%'){print "selected='selected'";}?>>Slight</option>



										<option value='150%' <?php if ($appyValues[$currLine][0] == '150%'){print "selected='selected'";}?>>1 1/2 Spacing</option>



										<option value='200%' <?php if ($appyValues[$currLine][0] == '200%'){print "selected='selected'";}?>>Double Space</option>



									<?php



									echo "



									</select>



									



								</div>



								<div class='delete-text-area-button delete-button-settings'>Delete this feature</div>



					</div>";



}



}



}//end creation of textareas



























$appyValues = array_reverse($appyValues);



// create lists that have already been placed



foreach ($appyValues as $metaTitle => $listCount) {



	if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



		if (strpos($metaTitle,'appy_options_list_title_') !== FALSE) { //narrow down to only list areas



		



			//create variables with meta values to be called



			$listCountandPageUnder = str_replace('appy_options_list_title_', '', $metaTitle);



			$listCountandPage = str_replace('_', '-', $listCountandPageUnder);



			







			



			



			echo "



			<div id='container-list-feature-".$listCountandPage."' class='feature-container list-container'>



			<h4>List Settings</h4>



			<input type='hidden' name='appy-options-list-title-".$listCountandPage."' />



			<label for='list-repeatable-".$listCountandPage."'>List Items</label>



			<div class='list-repeatable-container' id='list-repeatable-container-".$listCountandPage."'>";



			



			foreach ($appyValues as $currListItem => $currItemData) {



				$currListFeature = "appy_options_list_repeatable_list_" .  $listCountandPageUnder . "_item_";



				if (strpos($currListItem,$currListFeature) !== FALSE) {



				if (strpos($currListItem,'_option_') == FALSE) {



					$thisName = str_replace('_','-',$currListItem);



					$thisName = str_replace('-title','',$thisName);



					$thisNameID = str_replace('appy-options-','',$thisName);



					$thisNameID = str_replace('-title','',$thisNameID);



					



					//create variables for each option to be checked



					$optionBase = str_replace('_title', '', $currListItem);



					$listOptionType = $optionBase."_option_link_type";



					$listOptionExternal = $optionBase."_option_external_link";



					$listOptionInternal = $optionBase."_option_internal_link_hidden";







			



					echo "



						<input name='".$thisName."-title' id='".$thisNameID."' class='list-repeatable-item' value='".$currItemData[0]."'/>



						<span class='delete-list-item'>-</span>



						<div class='hidden-options-toggle' style='margin-top:-5px;'>Toggle Options</div>



						<div id='".$thisNameID."-options' class='hidden-options-area' style='display:none;'>



							<label for='".$thisNameID."-option-link-type'>Link type</label>



							<select name='".$thisName."-option-link-type' id='".$thisNameID."-option-link-type' class='list-item-option-link-type'>"; 



						?>



								<option value='empty' <?php if ($appyValues[$listOptionType][0] == 'empty'){print "selected";}?>>No link, just text</option>



								<option value='internal' <?php if ($appyValues[$listOptionType][0] == 'internal'){print "selected";}?>>Another page on this site</option>



								<option value='external' <?php if ($appyValues[$listOptionType][0] == 'external'){print "selected";}?>>External page</option>



						<?php



						echo "



							</select>



							<label ";



						if ($appyValues[$listOptionType][0] !== 'external') {



							echo "style='display:none;' ";



						}



						echo "for='".$thisNameID."-option-external-link'>Link URL</label>



							<input name='".$thisName."-option-external-link' id='".$thisNameID."-option-external-link' value='";



						if ($appyValues[$listOptionType][0] == 'external') {



							echo $appyValues[$listOptionExternal][0]. "'";



						} else {



							echo "http://' style='display:none;'";



						}



						echo "



							class='list-item-option-external-link' />



							<label ";



						if ($appyValues[$listOptionType][0] !== 'internal') {



							echo "style='display:none;' ";



						} 



						echo "for='".$thisNameID."-option-internal-link'>Choose Page</label>



							<select style='display:none;' id='".$thisNameID."-option-internal-link' class='list-item-options-list-pages'></select>



							<input name='".$thisName."-option-internal-link-hidden' id='".$thisNameID."-option-internal-link-hidden' type='hidden' class='hidden-internal-link' value='".$appyValues[$listOptionInternal][0]."'/>



						</div>";



					}



				}



			}



			



			



			echo "



			</div><br style='clear:both;' />



			<span class='add-list-item'>Add a list item +</span>



			<div class='delete-list-button delete-button-settings'>Delete this feature</div>



			<script>



				jQuery('.list-repeatable-container').slimscroll({



					height: '414px',



					disableFadeOut: true



				});



			</script>



			



			



			



			



			</div>";



			



			



		}



	}



}//end creation of list features



$appyValues = array_reverse($appyValues);



























// create social links that have already been placed



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_badge_set_social_') !== FALSE) {//narrow down to only social link padding top areas



					//create variables with meta values to be called



					global $plugin_folder_name;



					$socialCount = str_replace('appy_options_badge_set_social_', '', $metaTitle);



					$currBadgeSet = $metaTitle;



					



					$path = plugins_url();



					$path = ''.$path.'/'.$plugin_folder_name.'';



					$ipath = ''.$path.'/includes';







					



					//replace underscores with hyphens



					$socialCount = str_replace('_', '-', $socialCount);



					



					



					



					echo "



					<div id='container-social-".$socialCount."' class='feature-container social-container'>



					



						<h4>Social Settings</h4>



						



						<div class='hidden-options-toggle'>Toggle Options</div>



						



						<div class='hidden-options-area' id='options-social-".$socialCount."' style='display:none;'>



							<label for='badge-set-social-".$socialCount."'>Badge Set</label>



							<select name='appy-options-badge-set-social-".$socialCount."' id='badge-set-social-".$socialCount."'>";



						?>



								<option value='badges1' <?php if ($appyValues[$currBadgeSet][0] == 'badges1'){print "selected";}?>>Default</option>



								<option value='badges2' <?php if ($appyValues[$currBadgeSet][0] == 'badges2'){print "selected";}?>>Set 2</option>



								<option value='badges3' <?php if ($appyValues[$currBadgeSet][0] == 'badges3'){print "selected";}?>>Set 3</option>



								<option value='badges4' <?php if ($appyValues[$currBadgeSet][0] == 'badges4'){print "selected";}?>>Set 4</option>



								<option value='badges5' <?php if ($appyValues[$currBadgeSet][0] == 'badges5'){print "selected";}?>>Set 5</option>



								<option value='badges6' <?php if ($appyValues[$currBadgeSet][0] == 'badges6'){print "selected";}?>>Set 6</option>



								<option value='badges7' <?php if ($appyValues[$currBadgeSet][0] == 'badges7'){print "selected";}?>>Set 7</option>



								<option value='badges8' <?php if ($appyValues[$currBadgeSet][0] == 'badges8'){print "selected";}?>>Set 8</option>



						<?php



							echo "



							</select>



						</div>



						



						<div class='social-container' id='social-container-".$socialCount."'>



						



							<div class='social-settings-icons-box'>



								<ul>



									<li class='facebook-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/facebook.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/facebook.png);'";



										}



									echo"



									><p>Facebook</p></li>



									<li class='twitter-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/twitter.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/twitter.png);'";



										}



									echo "



									><p>Twitter</p></li>



									<li class='linkedin-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/linkedin.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/linkedin.png);'";



										}



									echo"



									><p>LinkedIn</p></li>



									<li class='youtube-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/youtube.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/youtube.png);'";



										}



									echo "



									><p>YouTube</p></li>



									<li class='googleplus-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/googleplus.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/googleplus.png);'";



										}



									echo "



									><p>GooglePlus</p></li>



									<li class='flickr-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/flickr.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/flickr.png);'";



										}



									echo "><p>Flickr</p></li>



									<li class='tumblr-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/tumblr.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/tumblr.png);'";



										}



									echo "><p>Tumblr</p></li>



									<li class='wordpress-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/wordpress.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/wordpress.png);'";



										}



									echo "><p>Wordpress</p></li>



									<li class='blogger-icon social-icon'";



										if ($appyValues[$currBadgeSet][0] == 'badges2') {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/blogger.png);background-size:37px auto;background-position:-2px -2px'";



										} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



											print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/blogger.png);'";



										}



									echo "><p>Blogger</p></li>



								</ul>



								<div class='social-settings-drag-into'>



									<ul>



										<span>Drag social sites into this area to add them to the screen. Then, click on the icon to edit the settings for each site.</span>";



								



								



								$appyValues = array_reverse($appyValues);



								foreach ($appyValues as $currSocial => $data) {



									$currSite = "appy_options_social_options_";



									if (strpos($currSocial,$currSite) !== FALSE) {



										$currSocial = str_replace("appy_options_social_options_", "", $currSocial);



										$socialCounttemp = str_replace("-", "_", $socialCount);



										$currSocial = str_replace($socialCounttemp, "", $currSocial);



										



										



										if (strpos($currSocial,'_window') == FALSE) {



											$currSocial = str_replace("_linkurl", "", $currSocial);



											$currSocial = str_replace("_", "", $currSocial);



											



											echo "



											<li class='".$currSocial."-icon social-icon ui-draggable in-list'";



												if ($appyValues[$currBadgeSet][0] == 'badges2') {



													print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/".$currSocial.".png);background-size:37px auto;background-position:-2px -2px'";



												} if (($appyValues[$currBadgeSet][0] == 'badges3') || ($appyValues[$currBadgeSet][0] == 'badges4') ||($appyValues[$currBadgeSet][0] == 'badges5')||($appyValues[$currBadgeSet][0] == 'badges6')||($appyValues[$currBadgeSet][0] == 'badges7')||($appyValues[$currBadgeSet][0] == 'badges8')) {



													print " style='background-image: url(".$ipath."/images/".$appyValues[$currBadgeSet][0]."/".$currSocial.".png);'";



												}



										echo



										"><p>".$currSocial."</p></li>";



										}



									}



								}



										



										



										



							echo "



									</ul>";



									



									



									



									



								foreach ($appyValues as $currSocial => $data) {



									$currSite = "appy_options_social_options_";



									if (strpos($currSocial,$currSite) !== FALSE) {



										$currSocial = str_replace("appy_options_social_options_", "", $currSocial);



										$socialCounttemp = str_replace("-", "_", $socialCount);



										$currSocial = str_replace($socialCounttemp, "", $currSocial);



											



											



											if (strpos($currSocial,'_window') == FALSE) {



												$currSocial = str_replace("_linkurl", "", $currSocial);



												$currSocial = str_replace("_", "", $currSocial);



												



												



												//create variables for each option to be checked



												$optionBase = "appy_options_social_options_".$socialCount."_".$currSocial;



												$optionBase = str_replace("-","_", $optionBase);



												$listOptionType = $optionBase."_linkurl";



												$listOptionWindow = $optionBase."_link_window";



												



												echo "



												<div style='display:none;' class='hidden-social-options' id='social-options-".$socialCount."-".$currSocial."'><h5>".$currSocial." Options</h5><label for='social-options-".$socialCount."-".$currSocial."-linkurl'>Link To</label><input name='appy-options-social-options-".$socialCount."-".$currSocial."-linkurl' id='social-options-".$socialCount."-".$currSocial."-linkurl' value='".$appyValues[$listOptionType][0]."'/><label for='social-options-".$socialCount."-".$currSocial."-link-window'>Open In New Window?</label><select name='appy-options-social-options-".$socialCount."-".$currSocial."-link-window' id='social-options-".$socialCount."-".$currSocial."-link-window'>";



												



												?>



													<option value='yes' <?php if ($appyValues[$listOptionWindow][0] == 'yes'){print "selected";}?>>Yes</option>



													<option value='no' <?php if ($appyValues[$listOptionWindow][0] == 'no'){print "selected";}?>>No</option>



												<?php 



												echo"



													</select><div class='delete-social-site'>Delete this site</div></div>";



											}



									}



								}



									



									



							echo "



									



									



									



									



									



								</div>";



								?>



								



								<script>



									jQuery("div.social-settings-drag-into ul").droppable({



										scope: "social-create",



										accept: ".social-settings-icons-box ul li:not('.in-list')",



										drop: function( event, ui ) {



											jQuery("li.social-screen-message").slideUp();



											jQuery(".hidden-social-options").slideUp();



											jQuery(ui.draggable).addClass('in-list');



											jQuery(this).append(jQuery(ui.draggable));



											var currSocial = jQuery(this).parents(".feature-container").attr("id").substr(17);



											var currSite = jQuery(ui.draggable).children("p").text().toLowerCase().replace(' ', '-');



											jQuery("#container-social-"+currSocial+" div.social-settings-drag-into").append("<div  class='hidden-social-options' id='social-options-"+currSocial+"-"+currSite+"'><h5>"+currSite+" Options</h5><label for='social-options-"+currSocial+"-"+currSite+"-linkurl'>Link To</label><input name='appy-options-social-options-"+currSocial+"-"+currSite+"-linkurl' id='social-options-"+currSocial+"-"+currSite+"-linkurl' /><label for='social-options-"+currSocial+"-"+currSite+"-link-window'>Open In New Window?</label><select name='appy-options-social-options-"+currSocial+"-"+currSite+"-link-window' id='social-options-"+currSocial+"-"+currSite+"-link-window'><option value='yes'>Yes</option><option value='no'>No</option></select><div class='delete-social-site'>Delete this site</div></div>");



											



											jQuery("#social-options-"+currSocial+"-"+currSite).slideDown();



											



											//make a new badge on the screen



											var currPage = jQuery("#current-page").text(),



											backImage = jQuery(ui.draggable).css("background-image");



											jQuery("li#screen-social-"+currSocial+" ul li.social-screen-message").slideUp();



											jQuery("li#screen-social-"+currSocial+" ul").append("<li style='background-image:"+backImage+"' class='screen-social-badge' id='screen-social-"+currSocial+"-"+currSite+"'></li>");



										}



									});







									//make the list of social sites draggable



									jQuery("div.social-settings-icons-box ul li").draggable({



										scope: "social-create",



										helper: "clone",



										revert: "invalid"







									});



								</script>



								<?php



								echo "



							</div>



						</div><div class='delete-divider-button delete-button-settings'>Delete this feature</div>



					</div>";



				



		}



	}



}//end creation of social links







$appyValues = array_reverse($appyValues);



// create dividers that have already been placed



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_divider_padding_top') !== FALSE) { //narrow down to only divider padding top areas



					//create variables with meta values to be called



					$dividerCount = str_replace('appy_options_divider_padding_top_', '', $metaTitle);



					$currPaddingTop = "appy_options_divider_padding_top_" . $dividerCount;



					$currPaddingBottom = "appy_options_divider_padding_bottom_" . $dividerCount;



					$currHeight = "appy_options_divider_height_" . $dividerCount;



					$currWidth = "appy_options_divider_width_" . $dividerCount;



					$currCorner = "appy_options_divider_border_radius_" . $dividerCount;



					$currColor = "appy_options_divider_color_" . $dividerCount;







					



					//replace underscores with hyphens



					$dividerCount = str_replace('_', '-', $dividerCount);



					



					



					



					echo "



					<div id='container-divider-".$dividerCount."' class='feature-container divider-container'>



						<h4>Divider Settings</h4>



						<div class='hidden-options-toggle'>Toggle Options</div>



						<div class='hidden-options-area' id='options-divider-".$dividerCount."' style='display:none;'>



							<label class='padding-top' for='divider-padding-top-".$dividerCount."'>Padding Top</label>



							<div class='slider-bar padding-top'></div>



							<input name='appy-options-divider-padding-top-".$dividerCount."' id='divider-padding-top-".$dividerCount."' value='";



							(!empty($appyValues[$currPaddingTop][0]) ? print $appyValues[$currPaddingTop][0] : print "10");



					echo "



							<label class='padding-bottom' for='divider-padding-bottom-".$dividerCount."'>Padding Bottom</label>



							<div class='slider-bar padding-bottom'></div>



							<input name='appy-options-divider-padding-bottom-".$dividerCount."' id='divider-padding-top-".$dividerCount."' value='".$appyValues[$currPaddingBottom][0]."'><br />



							<label class='height' for='divider-height-".$dividerCount."'>Height</label>



							<div class='slider-bar height'></div>



							<input name='appy-options-divider-height-".$dividerCount."' id='divider-height-".$dividerCount."' value='".$appyValues[$currHeight][0]."'><br />



							<label class='width' for='divider-width-".$dividerCount."'>Width</label>



							<div class='slider-bar width'></div>



							<input name='appy-options-divider-width-".$dividerCount."' id='divider-width-".$dividerCount."' value='".$appyValues[$currWidth][0]."'><br />



							<label class='border-radius' for='divider-border-radius-".$dividerCount."'>Corner Round</label>



							<div class='slider-bar border-radius'></div>



							<input name='appy-options-divider-border-radius-".$dividerCount."' id='divider-border-radius-".$dividerCount."' ".$appyValues[$currCorner][0]."'><br />



							<label for='divider-color-".$dividerCount."'>Color</label>



							<input name='appy-options-divider-color-".$dividerCount."' id='divider-color-".$dividerCount."' class='divider-color'><br /></div>



							<div class='delete-divider-button delete-button-settings'>Delete this feature</div>



							



							<script>



								jQuery('.slider-bar.padding-top').slider({



									value: '".$appyValues[$currPaddingTop][0]."',



									animate: 'slow',



									min: 0,



									max: 100,



									step: 1



								});



								jQuery('.slider-bar.padding-bottom').slider({



									value: '".$appyValues[$currPaddingBottom][0]."',



									animate: 'slow',



									min: 0,



									max: 100,



									step: 1



								});



								jQuery('.slider-bar.height').slider({



									value: '".$appyValues[$currHeight][0]."',



									animate: 'slow',



									min: 0,



									max: 50,



									step: 1



								});



								jQuery('.slider-bar.width').slider({



									value: '".$appyValues[$currWidth][0]."',



									animate: 'slow',



									min: 0,



									max: 100,



									step: 1



								});



								jQuery('.slider-bar.border-radius').slider({



									value: '".$appyValues[$currCorner][0]."',



									animate: 'slow',



									min: 0,



									max: 30,



									step: 1



								});







								//color for divider



								jQuery('.divider-color').spectrum({



									color: '".$appyValues[$currColor][0]."',



									showInput: true,



									className: 'full-spectrum',



									showInitial: true,



									showPalette: true,



									maxPaletteSize: 10,



									preferredFormat: 'hex',



									showButtons: false,



									move: function (color) {



										jQuery('#smart-screen li#screen-divider-".$dividerCount." .screen-divider-feature').css('background-color', color.toHexString());



									},



									change: function (color) {



										jQuery('#smart-screen li#screen-divider-".$dividerCount." .screen-divider-feature').css('background-color', color.toHexString());



									}



								});



							</script>



						



					</div>";



		}



	}



}//end creation of dividers











// create headers that have already been placed



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_header_content') !== FALSE) { //narrow down to only divider padding top areas



					//create variables with meta values to be called



					$headerCount = str_replace('appy_options_header_content_', '', $metaTitle);



					$currBack = "appy_options_site_option_heading_background_color_" . $headerCount;



					$currColor = "appy_options_site_option_heading_text_color" . $headerCount;



					$currSize = "appy_options_site_option_heading_size" . $headerCount;



					$currFont = "appy_options_site_option_heading_font" . $headerCount;



					$currContent = "appy_options_header_content_" . $headerCount;







					



					//replace underscores with hyphens



					$headerCount = str_replace('_', '-', $headerCount);



					



					echo"



						<div id='container-header-".$headerCount."' class='feature-container header-container'>



							<h4>Header Settings</h4>



							<label for='header-content-".$headerCount."'>Header Content</label>



							<textarea name='appy-options-header-content-".$headerCount."' class='header-content-area' id='header-content-".$headerCount."'>".$appyValues[$currContent][0]."</textarea>



							



							<div class='delete-header-area-button delete-button-settings'>Delete this feature</div>



					



						</div>";



					



		}



	}



}//end creation of dividers



















// create buttons that have already been placed



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_button_text_') !== FALSE) { //narrow down to only button text top areas



					//create variables with meta values to be called



					$buttonCount = str_replace('appy_options_button_text_', '', $metaTitle);



					$currText = "appy_options_button_text_" . $buttonCount;



					$currFontSize = "appy_options_button_font_size_" . $buttonCount;



					$currBorder = "appy_options_button_border_radius_" . $buttonCount;



					$currHeight = "appy_options_button_height_" . $buttonCount;



					$currWidth = "appy_options_button_width_" . $buttonCount;



					$currIlink = "appy_options_button_options_internal_link_hidden_" . $buttonCount;



					$currElink = "appy_options_button_options_external_link_" . $buttonCount;



					$currLinkType = "appy_options_button_options_link_type_" . $buttonCount;











					//replace underscores with hyphens



					$buttonCount = str_replace('_', '-', $buttonCount);



					



					



					



					echo "



						<div id='container-button-".$buttonCount."' class='feature-container button-container'>



							<h4>Button Settings</h4>



							<label for='button-text-".$buttonCount."'>Button Text</label>



							<textarea name='appy-options-button-text-".$buttonCount."' class='button-text-area' id='button-text-".$buttonCount."'>".$appyValues[$currText][0]."</textarea><br />



							<div class='hidden-options-toggle'>Toggle Options</div>



							<div class='hidden-options-area' id='options-button-".$buttonCount."' style='display:none;'>



								<label for='button-options-link-type-".$buttonCount."'>Link type</label>



								<select name='appy-options-button-options-link-type-".$buttonCount."' id='button-options-link-type".$buttonCount."' class='button-option-link-type'>";



								?>



									<option value='empty' <?php if ($appyValues[$currLinkType][0] == 'empty'){print "selected";}?>>No link, just text</option>



									<option value='internal' <?php if ($appyValues[$currLinkType][0] == 'internal'){print "selected";}?>>Another page on this site</option>



									<option value='external' <?php if ($appyValues[$currLinkType][0] == 'external'){print "selected";}?>>External page</option>



								<?php



							echo "</select>



								<label";



								if ($appyValues[$currLinkType][0] !== 'external') {



									echo " style='display:none;' ";



								}



							echo " for='button-options-external-link-".$buttonCount."'>Link URL</label>



								<input ";



								if ($appyValues[$currLinkType][0] !== 'external') {



									echo "style='display:none;' ";



								}



							echo "name='appy-options-button-options-external-link-".$buttonCount."' id='button-options-external-link-".$buttonCount."' value='".$appyValues[$currElink][0]."' class='button-option-external-link' />



								<label ";



								if ($appyValues[$currLinkType][0] !== 'internal') {



									echo "style='display:none;' ";



								}



							echo "for='button-options-internal-link-".$buttonCount."'>Choose Page</label>



								<select ";



								if ($appyValues[$currLinkType][0] !== 'internal') {



									echo "style='display:none;' ";



								}



							echo " id='button-options-internal-link-".$buttonCount."' class='button-options-list-pages'></select>



								<input name='appy-options-button-options-internal-link-hidden-".$buttonCount."' id='button-options-internal-link-hidden-".$buttonCount."' type='hidden' class='hidden-internal-link' value='".$appyValues[$currIlink][0]."'/>



							</div>



							<label class='width' for='button-width-".$buttonCount."'>Button Width</label>



							<div class='slider-bar button-width'></div>



							<input name='appy-options-button-width-".$buttonCount."' id='button-width-".$buttonCount."' value='".$appyValues[$currWidth][0]."'><br />



							<label class='line-height' for='button-height-".$buttonCount."'>Button Height</label>



							<div class='slider-bar button-height'></div>



							<input name='appy-options-button-height-".$buttonCount."' id='button-height-".$buttonCount."' value='".$appyValues[$currHeight][0]."'><br />



							<label class='font-size' for='button-font-size-".$buttonCount."'>Font Size</label>



							<div class='slider-bar font-size'></div>



							<input name='appy-options-button-font-size-".$buttonCount."' id='button-font-size-".$buttonCount."' value='".$appyValues[$currFontSize][0]."'><br />



							<label class='border-radius' for='button-border-radius-".$buttonCount."'>Border Radius</label>



							<div class='slider-bar border-radius'></div>



							<input name='appy-options-button-border-radius-".$buttonCount."' id='button-border-radius-".$buttonCount."' value='".$appyValues[$currBorder][0]."'><br />



							<div class='delete-header-area-button delete-button-settings'>Delete this feature</div>



							



							";?>



							



							<script>



								jQuery(".slider-bar.button-width").slider({



									animate: "slow",



									min: 23,



									max: 100,



									step: 1,



									value: <?php echo $appyValues[$currWidth][0];?>



								});



								jQuery(".slider-bar.button-height").slider({



									animate: "slow",



									min: 15,



									max: 90,



									step: 1,



									value: <?php echo $appyValues[$currHeight][0];?>



								});



								jQuery(".slider-bar.font-size").slider({



									animate: "slow",



									min: 9,



									max: 50,



									step: 1,



									value: <?php echo $appyValues[$currFontSize][0];?>



								});



								jQuery(".slider-bar.border-radius").slider({



									animate: "slow",



									min: 0,



									max: 40,



									step: 1,



									value: <?php echo $appyValues[$currBorder][0];?>



								});



							</script> <?php



							



							echo "



						







						</div>";



		}



	}



}//end creation of buttons















// create buttons that have already been placed



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_tap_call_text_') !== FALSE) { //narrow down to only button text top areas



					//create variables with meta values to be called



					$tapCallCount = str_replace('appy_options_tap_call_text_', '', $metaTitle);



					$currText = "appy_options_tap_call_text_" . $tapCallCount;



					$currFontSize = "appy_options_tap_call_font_size_" . $tapCallCount;



					$currBorder = "appy_options_tap_call_border_radius_" . $tapCallCount;



					$currHeight = "appy_options_tap_call_height_" . $tapCallCount;



					$currWidth = "appy_options_tap_call_width_" . $tapCallCount;



					$currNumber = "appy_options_tap_call_options_number_" . $tapCallCount;











					//replace underscores with hyphens



					$tapCallCount = str_replace('_', '-', $tapCallCount);



					



					



					



					echo "



						<div id='container-tap-call-".$tapCallCount."' class='feature-container tap-call-container'>



							<h4>Tap To Call Settings</h4>



							<label for='tap-call-text-".$tapCallCount."'>Tap To Call Text</label>



							<input name='appy-options-tap-call-text-".$tapCallCount."' class='tap-call-text-area' id='tap-call-text-".$tapCallCount."' value='".$appyValues[$currText][0]."' /><br />



							<label for='tap-call-options-number-".$tapCallCount."'>Phone Number</label>



							<input name='appy-options-tap-call-options-number-".$tapCallCount."' class='tap-call-number-area' id='tap-call-options-number-".$tapCallCount."' value='".$appyValues[$currNumber][0]."' /><br />



							<div class='hidden-options-toggle'>Toggle Options</div>



							<div class='hidden-options-area' id='options-tap-call-".$tapCallCount."' style='display:none;'>



								







								<label class='width' for='tap-call-width-".$tapCallCount."'>Button Width</label>



								<div class='slider-bar tap-call-width'></div>



								<input name='appy-options-tap-call-width-".$tapCallCount."' id='tap-call-width-".$tapCallCount."' value='".$appyValues[$currWidth][0]."'><br />



								<label class='line-height' for='tap-call-height-".$tapCallCount."'>Button Height</label>



								<div class='slider-bar tap-call-height'></div>



								<input name='appy-options-tap-call-height-".$tapCallCount."' id='tap-call-height-".$tapCallCount."' value='".$appyValues[$currHeight][0]."'><br />



								<label class='font-size' for='tap-call-font-size-".$tapCallCount."'>Font Size</label>



								<div class='slider-bar tap-call-font-size'></div>



								<input name='appy-options-tap-call-font-size-".$tapCallCount."' id='tap-call-font-size-".$tapCallCount."' value='".$appyValues[$currFontSize][0]."'><br />



								<label class='border-radius' for='tap-call-border-radius-".$tapCallCount."'>Border Radius</label>



								<div class='slider-bar tap-call-border-radius'></div>



								<input name='appy-options-tap-call-border-radius-".$tapCallCount."' id='tap-call-border-radius-".$tapCallCount."' value='".$appyValues[$currBorder][0]."'><br />



							</div>



							<div class='delete-header-area-button delete-button-settings'>Delete this feature</div>



							



							";?>



							



							<script>



								jQuery(".slider-bar.tap-call-width").slider({



									animate: "slow",



									min: 23,



									max: 100,



									step: 1,



									value: <?php echo $appyValues[$currWidth][0];?>



								});



								jQuery(".slider-bar.tap-call-height").slider({



									animate: "slow",



									min: 15,



									max: 90,



									step: 1,



									value: <?php echo $appyValues[$currHeight][0];?>



								});



								jQuery(".slider-bar.tap-call-font-size").slider({



									animate: "slow",



									min: 9,



									max: 50,



									step: 1,



									value: <?php echo $appyValues[$currFontSize][0];?>



								});



								jQuery(".slider-bar.tap-call-border-radius").slider({



									animate: "slow",



									min: 0,



									max: 40,



									step: 1,



									value: <?php echo $appyValues[$currBorder][0];?>



								});



							</script> <?php



							



							echo "



						







						</div>";



		}



	}



}//end creation of buttons











// create tap to email buttons that have already been placed



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_tap_email_text_') !== FALSE) { //narrow down to only button text top areas



					//create variables with meta values to be called



					$tapCallCount = str_replace('appy_options_tap_email_text_', '', $metaTitle);



					$currText = "appy_options_tap_email_text_" . $tapCallCount;



					$currFontSize = "appy_options_tap_email_font_size_" . $tapCallCount;



					$currBorder = "appy_options_tap_email_border_radius_" . $tapCallCount;



					$currHeight = "appy_options_tap_email_height_" . $tapCallCount;



					$currWidth = "appy_options_tap_email_width_" . $tapCallCount;



					$currAddress = "appy_options_tap_email_options_address_" . $tapCallCount;











					//replace underscores with hyphens



					$tapCallCount = str_replace('_', '-', $tapCallCount);



					



					



					



					echo "



						<div id='container-tap-email-".$tapCallCount."' class='feature-container tap-email-container'>



							<h4>Tap To Email Settings</h4>



							<label for='tap-email-text-".$tapCallCount."'>Tap To Email Text</label>



							<input name='appy-options-tap-email-text-".$tapCallCount."' class='tap-email-text-area' id='tap-email-text-".$tapCallCount."' value='".$appyValues[$currText][0]."' /><br />



							<label for='tap-email-options-address-".$tapCallCount."'>Email Adress</label>



							<input name='appy-options-tap-email-options-address-".$tapCallCount."' class='tap-email-address-area' id='tap-email-options-address-".$tapCallCount."' value='".$appyValues[$currAddress][0]."' /><br />



							<div class='hidden-options-toggle'>Toggle Options</div>



							<div class='hidden-options-area' id='options-tap-email-".$tapCallCount."' style='display:none;'>



								







								<label class='width' for='tap-email-width-".$tapCallCount."'>Button Width</label>



								<div class='slider-bar tap-email-width'></div>



								<input name='appy-options-tap-email-width-".$tapCallCount."' id='tap-email-width-".$tapCallCount."' value='".$appyValues[$currWidth][0]."'><br />



								<label class='line-height' for='tap-email-height-".$tapCallCount."'>Button Height</label>



								<div class='slider-bar tap-email-height'></div>



								<input name='appy-options-tap-email-height-".$tapCallCount."' id='tap-email-height-".$tapCallCount."' value='".$appyValues[$currHeight][0]."'><br />



								<label class='font-size' for='tap-email-font-size-".$tapCallCount."'>Font Size</label>



								<div class='slider-bar tap-email-font-size'></div>



								<input name='appy-options-tap-email-font-size-".$tapCallCount."' id='tap-email-font-size-".$tapCallCount."' value='".$appyValues[$currFontSize][0]."'><br />



								<label class='border-radius' for='tap-email-border-radius-".$tapCallCount."'>Border Radius</label>



								<div class='slider-bar tap-email-border-radius'></div>



								<input name='appy-options-tap-email-border-radius-".$tapCallCount."' id='tap-email-border-radius-".$tapCallCount."' value='".$appyValues[$currBorder][0]."'><br />



							</div>



							<div class='delete-header-area-button delete-button-settings'>Delete this feature</div>



							



							";?>



							



							<script>



								jQuery(".slider-bar.tap-email-width").slider({



									animate: "slow",



									min: 23,



									max: 100,



									step: 1,



									value: <?php echo $appyValues[$currWidth][0];?>



								});



								jQuery(".slider-bar.tap-email-height").slider({



									animate: "slow",



									min: 15,



									max: 90,



									step: 1,



									value: <?php echo $appyValues[$currHeight][0];?>



								});



								jQuery(".slider-bar.tap-email-font-size").slider({



									animate: "slow",



									min: 9,



									max: 50,



									step: 1,



									value: <?php echo $appyValues[$currFontSize][0];?>



								});



								jQuery(".slider-bar.tap-email-border-radius").slider({



									animate: "slow",



									min: 0,



									max: 40,



									step: 1,



									value: <?php echo $appyValues[$currBorder][0];?>



								});



							</script> <?php



							



							echo "



						







						</div>";



		}



	}



}//end creation of buttons































// create images that have already been placed



		foreach ($appyValues as $metaTitle => $textCount) {



			if (strpos($metaTitle,'appy_options_') !== FALSE) { //check if this is an appy option



				if (strpos($metaTitle,'appy_options_image_src') !== FALSE) { //narrow down to only button text top areas



					//create variables with meta values to be called



					$imageCount = str_replace('appy_options_image_src_', '', $metaTitle);



					$currWidth = "appy_options_image_width_" . $imageCount;



					$currPaddingTop = "appy_options_image_padding_top_" . $imageCount;



					$currPaddingBottom = "appy_options_image_padding_bottom_" . $imageCount;



					$currBorder = "appy_options_image_border_radius_" . $imageCount;



					$currShadow = "appy_options_image_shadow_" . $imageCount;



					$currImage = "appy_options_image_src_" . $imageCount;











					//replace underscores with hyphens



					$imageCount = str_replace('_', '-', $imageCount);



					



					echo "



					



					<div id='container-image-".$imageCount."' class='feature-container image-container' style='display:none;'>



						<h4>Image Settings</h4>







						<input id='upload-image-".$imageCount."' type='hidden' size='36' name='appy-options-image-src-".$imageCount."' class='upload-image-input' value='".$appyValues[$currImage][0]."' />



						<input id='upload-image-button-".$imageCount."' class='button upload-image-feature-button' type='button' value='Upload Image' /><br />Click the upload button to use the native WordPress uploader. You can drag and drop any image file to upload it directly onto your site!</label>



						<div class='hidden-options-toggle'>Toggle Options</div>



						<div class='hidden-options-area' id='options-image-".$imageCount."' style='display:none;'>



							<label class='width' for='image-width-".$imageCount."'>Image Width</label>



							<div class='slider-bar width'></div>



							<input name='appy-options-image-width-".$imageCount."' id='image-width-".$imageCount."' value='".$appyValues[$currWidth][0]."'><br />";



						?>



							<script>



								jQuery(".slider-bar.width").slider({



									animate: "slow",



									min: 5,



									max: 100,



									step: 1,



									value: <?php print $appyValues[$currWidth][0];?>



								});



							</script>



						<?php echo "



					



							<label class='padding-top' for='image-padding-top-".$imageCount."'>Top Padding</label>



							<div class='slider-bar padding-top'></div>



							<input name='appy-options-image-padding-top-".$imageCount."' id='image-padding-top".$imageCount."' value='".$appyValues[$currPaddingTop][0]."'><br />";



						?>



							<script>



								jQuery(".slider-bar.padding-top").slider({



									animate: "slow",



									min: 0,



									max: 100,



									step: 1,



									value: <?php print $appyValues[$currPaddingTop][0];?>



								});



							</script>



						<?php echo "



						



							<label class='padding-bottom' for='image-padding-bottom-".$imageCount."'>Bottom Padding</label>



							<div class='slider-bar padding-bottom'></div>



							<input name='appy-options-image-padding-bottom-".$imageCount."' id='image-padding-bottom-".$imageCount."' value='".$appyValues[$currPaddingBottom][0]."'><br />";



						?>



							<script>



								jQuery(".slider-bar.padding-bottom").slider({



									animate: "slow",



									min: 0,



									max: 100,



									step: 1,



									value: <?php print $appyValues[$currPaddingBottom][0];?>



								});



							</script>



								



						<?php echo "



						



							<label class='border-radius' for='image-border-radius-".$imageCount."'>Border Radius</label>



							<div class='slider-bar border-radius'></div>



							<input name='appy-options-image-border-radius-".$imageCount."' id='image-border-radius-".$imageCount."' value='".$appyValues[$currBorder][0]."'><br />";



						?>



							<script>



								jQuery(".slider-bar.border-radius").slider({



									animate: "slow",



									min: 0,



									max: 30,



									step: 1,



									value: <?php print $appyValues[$currBorder][0];?>



								});



							</script>



						



						<?php echo "



							



							<label for='image-shadow-".$imageCount."'>Show Shadow?</label>



							<select class='box-shadow-option' name='appy-options-image-shadow-".$imageCount."' id='image-shadow-".$imageCount."'>";



						?>



							<option value='no' <?php if ($appyValues[$currShadow][0] == 'no') {print "selected='selected'";}?>>No</option>



							<option value='yes' <?php if ($appyValues[$currShadow][0] == 'yes') {print "selected='selected'";}?>>Yes</option>



						<?php echo "



							</select>



						</div>



						



						<div class='delete-text-area-button delete-button-settings'>Delete this feature</div>



					



					



					



					</div>";



		}



	}



}//end creation of images



































echo "							



		











</div>



</div>";



















}























add_action( 'save_post', 'mobile_appy_save_meta', 10, 2 );







/* Save the meta box's post metadata. */



function mobile_appy_save_meta( $post_id, $post ) {







	/* Verify the nonce before proceeding. */



	if ( !isset( $_POST['mobile_appy_save_nonce'] ) || !wp_verify_nonce( $_POST['mobile_appy_save_nonce'], basename( __FILE__ ) ) )



		return $post_id;







	/* Get the post type object. */



	$post_type = get_post_type_object( $post->post_type );







	/* Check if the current user has permission to edit the post. */



	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )



		return $post_id;



		







	//go through $_POST data and find the keys that start with 'appy-options-', these are the appy data. Then, go through each and update them one by one, no matter how many there are. This will loop through all $_POST values



	foreach ($_POST as $key => $data) {



		if (strpos($key,'appy-options-') !=='') { //find appy data



			if (strpos($key,'deleted') !== FALSE) { //deleted pages have 'deleted' amended to fields. Let's find those so they aren't saved



				$thisMetad = str_replace("-deleted","", $key); //remove 'deleted' because we want to delete the original meta key ('deleted' is just to let us temporarily know that the value should be deleted



				$thisMetad = str_replace("-","_", $thisMetad); //this replaces the - with _ since the actual post meta key uses _



				delete_post_meta($post_id, $thisMetad);



			}



			if (strpos($key,'deleted') == FALSE) {



			$thisMeta = str_replace("-","_", $key); //this replaces the - with _ since the actual post meta key uses _



				if(strpos($key,'appy_options_text_content_') !== FALSE) {



					$data = str_replace("\r",'<br>',$data);



				}



			update_post_meta($post_id, $thisMeta, $data ); //this updates each new meta value, no matter how many there are



			}







		}



	}











}



//die(print_r($_POST));











?>