jQuery(document).ready(function ($) {



goToNewPage()



	//make the screen area scrollable if it gets too large



				$('.screen-page').slimscroll({

					height: '480px',

					disableFadeOut: true

				});



				

				





    //Spectrum color Picker

    $("#site-option-background-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $("#smart-screen").css("background-color", color.toHexString());

        },

        change: function (color) {

            $("#smart-screen").css("background-color", color.toHexString());

        }

    });





    $("#site-option-list-background-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $(".screen-list-feature ul li").css("background-color", color.toHexString());

        },

        change: function (color) {

            $(".screen-list-feature ul li").css("background-color", color.toHexString());

        }

    });



    $("#site-option-list-item-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $(".screen-list-feature ul li a.inside-list-item").css("color", color.toHexString());

        },

        change: function (color) {

            $(".screen-list-feature ul li a.inside-list-item").css("color", color.toHexString());

        }

    });



    $("#site-option-bottom-menu-background-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $("#bottom-menu-holder").css("background-color", color.toHexString());

        },

        change: function (color) {

            $("#bottom-menu-holder").css("background-color", color.toHexString());

        }

    });



    $("#site-option-side-menu-background-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $("#side-menu-actual").css("background-color", color.toHexString());

        },

        change: function (color) {

            $("#side-menu-actual").css("background-color", color.toHexString());

        }

    });



    $("#site-option-side-menu-text-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $(".side-menu-item").css("color", color.toHexString());

        },

        change: function (color) {

            $(".side-menu-item").css("color", color.toHexString());

        }

    });



    $("#site-option-bottom-menu-text-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $(".bottom-menu-item").css("color", color.toHexString());

        },

        change: function (color) {

            $(".bottom-menu-item").css("color", color.toHexString());

        }

    });



    $("#site-option-body-size").on("change", function () {

        $("#smart-screen-visible").css("font-size", $(this).val());

    });

    $("#site-option-body-font").on("change", function () {

        $("#smart-screen-visible").css("font-family", $(this).val());

    });

    $("#site-option-body-text-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $("#smart-screen-visible").css("color", color.toHexString());

        },

        change: function (color) {

            $("#smart-screen-visible").css("color", color.toHexString());

        }

    });



    $("#site-option-heading-text-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $("#smart-screen-visible .screen-header h1").css("color", color.toHexString());

        },

        change: function (color) {

            $("#smart-screen-visible .screen-header h1").css("color", color.toHexString());

        }

    });    

	$("#site-option-heading-background-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $("#smart-screen-visible .screen-header").css("background-color", color.toHexString());

        },

        change: function (color) {

            $("#smart-screen-visible .screen-header").css("background-color", color.toHexString());

        }

    });

	$("#site-option-button-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $("#smart-screen-visible .screen-button-feature").css("background-color", color.toHexString());

            $("#smart-screen-visible .screen-tap-call-feature").css("background-color", color.toHexString());

            $("#smart-screen-visible .screen-tap-email-feature").css("background-color", color.toHexString());

        },

        change: function (color) {

            $("#smart-screen-visible .screen-button-feature").css("background-color", color.toHexString());

            $("#smart-screen-visible .screen-tap-call-feature").css("background-color", color.toHexString());

            $("#smart-screen-visible .screen-tap-email-feature").css("background-color", color.toHexString());

        }

    });

	$("#site-option-button-text-color").spectrum({

        showInput: true,

        className: "full-spectrum",

        showInitial: true,

        showPalette: true,

        maxPaletteSize: 10,

        preferredFormat: "hex",

        showButtons: false,

        move: function (color) {

            $("#smart-screen-visible .screen-button-feature").css("color", color.toHexString());

            $("#smart-screen-visible .screen-tap-call-feature").css("color", color.toHexString());

            $("#smart-screen-visible .screen-tap-email-feature").css("color", color.toHexString());

        },

        change: function (color) {

            $("#smart-screen-visible .screen-button-feature").css("color", color.toHexString());

            $("#smart-screen-visible .screen-tap-call-feature").css("color", color.toHexString());

            $("#smart-screen-visible .screen-tap-email-feature").css("color", color.toHexString());

        }

    });

	









    // FORMATTING



    //set up the left hand menu accordion

    $("#left-settings-accordion").accordion({

        collapsible: true,

        heightStyle: "content",

        active: false

    });



    // set up 'Site Settings' tabs area

    $("#site-settings-options-area").tabs();







    //extend the accordion when site settings are being shown

    $("#left-settings-accordion").on("accordionbeforeactivate", function (event, ui) {

        if ($(ui.newHeader).attr("id") == 'site-settings-header-block') {

            closeSettingsPanel();

            $("#left-settings-accordion").animate({

                width: "380px"

            }, "slow", "swing", function () {

                $("#site-settings-options-area").slideDown("fast");

            });

        }

        if ($(ui.newHeader).attr("id") !== 'site-settings-header-block') {

            $("#left-settings-accordion").animate({

                width: "17%"

            }, "slow", "swing", function () {

                $("#site-settings-options-area").hide();

            });

        }

    });









    //set up array full of feature options that can be added

    var featureList = ["Header", "Text", "Image", "List", "Divider", "Social Links", "Button", "Tap To Call", "Tap To Email"];



    //loop through each feature and add it to list, making each li draggable and connected to the sortable list on the screen

    for (i = 0; i < featureList.length; i++) {

        $("<li class='option-" + featureList[i] + "'>" + featureList[i] + "</li>").draggable({

            helper: function() {

	return $(this).clone().attr('class', 'ui-draggable-dragging').css('height', '50px');

},

            revert: false,

            appendTo: "#feature-list",

            //connect each li to the sortable list so features can be put into a specifc spot

            containment: "#holder",

            connectToSortable: ".screen-list"

        }).disableSelection().appendTo("#feature-listing");

    }







    //make the list on first page a sortable

    $(".screen-list").sortable({

        axis: "y",

        helper: "clone",

        update: function (event, ui) {

            if ($(ui.item).is('[class*=on-screen-feature]')) {

				//update the current order

                var currPage = $("#current-page").text();

				var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

				$("#screen-page-"+currPage+"-order").val(screenOrder);

            } else {

                checkNewFeatureType(event, ui);

            }

        }

    });





    // anytime a feature is added to any page, it should be sent here to sort out what type of feature was added.

    function checkNewFeatureType(event, ui) {

        var featureType = $(ui.item).text();

        if (featureType == "Header") {

			var currPage = $("#current-page").text();

		

			if ($("#screen-page-"+currPage+" .screen-header").length !== 1) {

				closeSettingsPanel();

				clearCurrentSettings();

				createHeaderSettings(ui);

				openSettingsPanel();

			} else if ($("#screen-page-"+currPage+" .screen-header").is('[class*=deleted]')) { 

				

					closeSettingsPanel();

					clearCurrentSettings();

					createHeaderSettings(ui);

					openSettingsPanel();

			} else {

				$(ui.item).remove();

				$("#holder").append("<div class='delete-message-dialog delete-warning-text'>Only one header is allowed per page. Sorry, but it's for your own good.</div>");

				$(".delete-message-dialog").dialog({

					open: function () {

						$(".ui-dialog-buttonpane").find("button:contains('DELETE')").addClass("big-delete-button");

					},

					modal: true,

					width: "385px",

					closeText: "Close This",

					height: "auto",

					hide: "fade",

					show: "fade",

					title: "Not Allowed",

					resizable: false,

					buttons: {

						close: function (event, ui) {

							$(".delete-message-dialog").remove();

						}

					}

				});

			}

        }

        if (featureType == "Text") {

            closeSettingsPanel();

            clearCurrentSettings();

            createTextSettings(ui);

            openSettingsPanel();

        }

        if (featureType == "Image") {

            closeSettingsPanel();

            clearCurrentSettings();

            createImageSettings(ui);

            openSettingsPanel();

        }

        if (featureType == "List") {

            closeSettingsPanel();

            clearCurrentSettings();

            createListSettings(ui);

            openSettingsPanel();

        }

        if (featureType == "Divider") {

            closeSettingsPanel();

            clearCurrentSettings();

            createDividerSettings(ui);

            openSettingsPanel();

        }

        if (featureType == "Social Links") {

            closeSettingsPanel();

            clearCurrentSettings();

            createSocialSettings(ui);

            openSettingsPanel();

        }

        if (featureType == "Button") {

            closeSettingsPanel();

            clearCurrentSettings();

            createButtonSettings(ui);

            openSettingsPanel();

        }

        if (featureType == "Tap To Call") {

            closeSettingsPanel();

            clearCurrentSettings();

            createTapToCallSettings(ui);

            openSettingsPanel();

        }

        if (featureType == "Tap To Email") {

            closeSettingsPanel();

            clearCurrentSettings();

            createTapToEmailSettings(ui);

            openSettingsPanel();

        }

    }







    //---Functions for creating NEW feature settings



    //this will create settings for a NEW heading feature

    function createHeaderSettings(ui) {

		//get current page

        var currPage = $("#current-page").text();



	

        //add a paragraph class to the item on the screen

        $(ui.item).addClass("screen-header");

        $(ui.item).addClass("on-screen-feature");

		var thisTextColor = $("#site-option-heading-text-color").spectrum("get");

        $(ui.item).html("<h1 style='font-family:" + ($("#site-option-heading-font").val()) +";color:"+thisTextColor+";font-size:" + ($("#site-option-heading-size").val()) +"'>Header</h1>");

		var thisBackGround = $("#site-option-heading-background-color").spectrum("get");

		$(ui.item).css("background-color", ""+thisBackGround+"");

        



        //get number of paragraphs on this current page and ammend ID

        $(ui.item).attr("id", "screen-header-page-" + currPage);



        //create a feature container

        $("#settings-area").append("<div id='container-header-page-" + currPage + "' class='feature-container header-container'></div>");



        //create heading

        $("#container-header-page-" + currPage).append("<h4>Header Settings</h4>");

		

		//create content textarea

        $("#container-header-page-" + currPage).append("<label for='header-content-page-" + currPage + "'>Header Content</label>");

        $("#container-header-page-" + currPage).append("<textarea name='appy-options-header-content-page-" + currPage + "' class='header-content-area' id='header-content-page-" + currPage + "'>Header</textarea>");

		

		//create delete button

        $("#container-header-page-" + currPage).append("<div class='delete-header-area-button delete-button-settings'>Delete this feature</div>");

		

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);



		

}









    //this will create settings for a NEW text feature

    function createTextSettings(ui) {

        //add a paragraph class to the item on the screen

        $(ui.item).addClass("screen-text");

        $(ui.item).addClass("on-screen-feature");

        $(ui.item).html("<div class='outside-screen-text' style='font-size:14px;color:#555;'><div class='inside-screen-text' name='text-box-save'>This is a text feature. Use the panel on the right to edit this text. You can also click on 'Toggle Options' to configure this are even more.</div></div>");



        //get current page

        var currPage = $("#current-page").text();



        //get number of paragraphs on this current page and ammend ID

        var textCount = $("#screen-page-" + currPage + " .screen-text").length;

        $(ui.item).attr("id", "screen-text-" + textCount + "-page-" + currPage);



        //create a feature container

        $("#settings-area").append("<div id='container-text-" + textCount + "-page-" + currPage + "' class='feature-container text-container'></div>");



        //create heading

        $("#container-text-" + textCount + "-page-" + currPage).append("<h4>Text Settings</h4>");



        //create content textarea

        $("#container-text-" + textCount + "-page-" + currPage).append("<label for='text-content-" + textCount + "-page-" + currPage + "'>Text Content</label>");

        $("#container-text-" + textCount + "-page-" + currPage).append("<textarea name='appy-options-text-content-" + textCount + "-page-" + currPage + "' class='text-content-area' id='text-content-" + textCount + "-page-" + currPage + "'>This is a text feature. Use the panel on the right to edit this text. You can also click on 'Toggle Options' to configure this are even more.</textarea>");

		

		//add instruction area

		$("#container-text-" + textCount + "-page-" + currPage).append("<div class='settings-instructions'><em>You may include any HTML code like...</em><code>&#60;a href='LINK'&#62;Label&#60;/a&#62;</code><code>&#60;div style=''&#62;&#60;/div&#62;</code><code>&#60;img src='' /&#62;</code></div>");



        //create drop down area for options

        $("#container-text-" + textCount + "-page-" + currPage).append("<div class='hidden-options-toggle'>Toggle Options</div>");

        $("#container-text-" + textCount + "-page-" + currPage).append("<div class='hidden-options-area' id='options-text-" + textCount + "-page-" + currPage + "' style='display:none;'></div>");



        //create border-radius option

        $("#options-text-" + textCount + "-page-" + currPage).append("<label class='font-size' for='text-size-" + textCount + "-page-" + currPage + "'>Text Size</label>");

        $("#options-text-" + textCount + "-page-" + currPage).append("<div class='slider-bar font-size' />");

        $("#options-text-" + textCount + "-page-" + currPage).append("<input name='appy-options-text-size-" + textCount + "-page-" + currPage + "' id='text-size-" + textCount + "-page-" + currPage + "' value='14'><br />");



        $(".slider-bar.font-size").slider({

            animate: "slow",

            min: 8,

            max: 50,

            step: 1,

			value: 14

        });





        //create color selector

        $("#options-text-" + textCount + "-page-" + currPage).append("<label for='text-color-" + textCount + "-page-" + currPage + "'>Text Color</label>");

        $("#options-text-" + textCount + "-page-" + currPage).append("<input name='appy-options-text-color-" + textCount + "-page-" + currPage + "' id='text-color-" + textCount + "-page-" + currPage + "' /><br />");

        $("#text-color-" + textCount + "-page-" + currPage).spectrum({

			color: "#555555",

            showInput: true,

            className: "full-spectrum",

            showInitial: true,

            showPalette: true,

            maxPaletteSize: 10,

            preferredFormat: "hex",

            showButtons: false,

            move: function (color) {

                var currContent = $(this).attr("id").substr(11);

                $("#screen-text-" + currContent +" .inside-screen-text").css("color", color.toHexString());

            },

            change: function (color) {

                var currContent = $(this).attr("id").substr(11);

                $("#screen-text-" + currContent).css("color", color.toHexString());

            }

        });



        //create alignment selector

        $("#options-text-" + textCount + "-page-" + currPage).append("<label for='text-style-" + textCount + "-page-" + currPage + "'>Text Alignment</label>");

        $("#options-text-" + textCount + "-page-" + currPage).append("<select name='appy-options-text-alignment-" + textCount + "-page-" + currPage + "' class='text-alignment-select' id='text-alignment-" + textCount + "-page-" + currPage + "'><option value='left' selected='selected'>Left</option><option value='center'>Center</option><option value='right'>Right</option><option value='justify'>Justify</option></select><br />");



        //create font-style selector

        $("#options-text-" + textCount + "-page-" + currPage).append("<label for='text-style-" + textCount + "-page-" + currPage + "'>Font Style</label>");

        $("#options-text-" + textCount + "-page-" + currPage).append("<select class='text-style-selector' name='appy-options-text-style-" + textCount + "-page-" + currPage + "' id='text-style-" + textCount + "-page-" + currPage + "'><option value='normal' selected='selected'>Normal</option><option value='bold'>Bold</option><option value='italic'>Italic</option><option value='bold-italic'>Bold Italic</option></select><br />");



        //create font line-height selector

        $("#options-text-" + textCount + "-page-" + currPage).append("<label for='text-line-height-" + textCount + "-page-" + currPage + "'>Line Height</label>");

        $("#options-text-" + textCount + "-page-" + currPage).append("<select name='appy-options-text-line-height-" + textCount + "-page-" + currPage + "' class='text-line-height' id='text-line-height-" + textCount + "-page-" + currPage + "'><option value='85%'>Tight</option><option value='100%'>Normal</option><option value='125%'>Slight</option><option value='150%' selected='selected'>1 1/2 Spacing</option><option value='200%'>Double Space</option>");



        //create delete button

        $("#container-text-" + textCount + "-page-" + currPage).append("<div class='delete-text-area-button delete-button-settings'>Delete this feature</div>");

		

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);

		





    }







    //this will create settings for a NEW image feature

    function createImageSettings(ui) {



        //add an image class to the item on the screen

        $(ui.item).addClass("screen-image");

        $(ui.item).addClass("on-screen-feature");

		

		var imageBase = $("#phone-space").css("background-image");

		imageBase = imageBase.replace('\'', '"').replace('iphone-mockup3.png")', '').replace('url("', '');

		imageBase = imageBase.replace('iphone-mockup3.png)', '').replace('url(', '');

		

        $(ui.item).html("<img src='"+imageBase+"camera-placeholder.png' class='screen-image-placeholder' />");



        //get current page

        var currPage = $("#current-page").text();



        //get number of paragraphs on this current page and ammend ID

        var imageCount = $("#screen-page-" + currPage + " .screen-image").length;

        $(ui.item).attr("id", "screen-image-" + imageCount + "-page-" + currPage);



        //create a feature container

        $("#settings-area").append("<div id='container-image-" + imageCount + "-page-" + currPage + "' class='feature-container image-container'></div>");



        //create a title

        $("#container-image-" + imageCount + "-page-" + currPage).append("<h4>Image Settings</h4>");

		

		//create image upload area

        $("#container-image-" + imageCount + "-page-" + currPage).append("<input id='upload-image-" + imageCount + "-page-" + currPage+"' type='hidden' size='36' name='appy-options-image-src-" + imageCount + "-page-" + currPage+"' class='upload-image-input' value='"+imageBase+"camera-placeholder.png' /><input id='upload-image-button-" + imageCount + "-page-" + currPage+"' class='button upload-image-feature-button' type='button' value='Upload Image' /><br />Click the upload button to use the native WordPress uploader. You can drag and drop any image file to upload it directly onto your site!</label>");

        

		

		//create drop down area for options

        $("#container-image-" + imageCount + "-page-" + currPage).append("<div class='hidden-options-toggle'>Toggle Options</div>");

        $("#container-image-" + imageCount + "-page-" + currPage).append("<div class='hidden-options-area' id='options-image-" + imageCount + "-page-" + currPage+"' style='display:none;'></div>");



        //create width option

        $("#options-image-" + imageCount + "-page-" + currPage).append("<label class='width' for='image-width-" + imageCount + "-page-" + currPage+"'>Image Width</label>");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<div class='slider-bar width' />");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<input name='appy-options-image-width-" + imageCount + "-page-" + currPage+"' id='image-width-" + imageCount + "-page-" + currPage+"' value='50'><br />");



        $(".slider-bar.width").slider({

            animate: "slow",

            min: 5,

            max: 100,

            step: 1,

			value: 50

        });

		

		//create top padding option

        $("#options-image-" + imageCount + "-page-" + currPage).append("<label class='padding-top' for='image-padding-top-" + imageCount + "-page-" + currPage+"'>Top Padding</label>");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<div class='slider-bar padding-top' />");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<input name='appy-options-image-padding-top-" + imageCount + "-page-" + currPage+"' id='image-padding-top" + imageCount + "-page-" + currPage+"' value='10'><br />");



        $(".slider-bar.padding-top").slider({

            animate: "slow",

            min: 0,

            max: 100,

            step: 1,

			value: 10

        });

		

		//create bottom padding option

        $("#options-image-" + imageCount + "-page-" + currPage).append("<label class='padding-bottom' for='image-padding-bottom-" + imageCount + "-page-" + currPage+"'>Bottom Padding</label>");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<div class='slider-bar padding-bottom' />");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<input name='appy-options-image-padding-bottom-" + imageCount + "-page-" + currPage+"' id='image-padding-bottom-" + imageCount + "-page-" + currPage+"' value='10'><br />");



        $(".slider-bar.padding-bottom").slider({

            animate: "slow",

            min: 0,

            max: 100,

            step: 1,

			value: 10

        });



		//create boorder radius option

        $("#options-image-" + imageCount + "-page-" + currPage).append("<label class='border-radius' for='image-border-radius-" + imageCount + "-page-" + currPage+"'>Border Radius</label>");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<div class='slider-bar border-radius' />");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<input name='appy-options-image-border-radius-" + imageCount + "-page-" + currPage+"' id='image-border-radius-" + imageCount + "-page-" + currPage+"' value='3'><br />");



        $(".slider-bar.border-radius").slider({

            animate: "slow",

            min: 0,

            max: 30,

            step: 1,

			value: 3

        });





		//create shadow option

        $("#options-image-" + imageCount + "-page-" + currPage).append("<label for='image-shadow-" + imageCount + "-page-" + currPage+"'>Show Shadow?</label>");

        $("#options-image-" + imageCount + "-page-" + currPage).append("<select class='box-shadow-option' name='appy-options-image-shadow-" + imageCount + "-page-" + currPage+"' id='image-shadow-" + imageCount + "-page-" + currPage+"'><option value='no'>No</option><option value='yes' selected='selected'>Yes</option></select>");





       



		

		

		//create delete button

        $("#container-image-" + imageCount +"-page-" + currPage).append("<div class='delete-text-area-button delete-button-settings'>Delete this feature</div>");

		

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);



    }







    //this will create settings for a NEW list feature

    function createListSettings(ui) {



        //add a list class to the item on the screen

        $(ui.item).addClass("screen-list-feature");

        $(ui.item).empty();

        $(ui.item).addClass("on-screen-feature");



        //get current page

        var currPage = $("#current-page").text();



        //get number of lists on this current page and ammend ID

        var listCount = $("#screen-page-" + currPage + " .screen-list-feature").length;

        $(ui.item).attr("id", "screen-list-feature-" + listCount + "-page-" + currPage);



        //add one to the list counter

        var thisVal = $("#list-feature-count").val();

        $("#list-feature-count").val(parseInt(thisVal, 10) + 1);



        //add a first list item to the list on screen

        $("#screen-list-feature-" + listCount + "-page-" + currPage).append("<ul id='screen-list-feature-list-" + listCount + "-page-" + currPage + "'><li style='background-color:"+ ($("#site-option-list-background-color").val()) +";color:"+ ($("#site-option-list-item-color").val()) +"' id='screen-list-feature-list-" + listCount + "-page-"+currPage+"-item-1'><a style='font-size:"+ ($("#site-option-list-item-size").val()) +"' class='inside-list-item' id='inside-list-" + listCount + "-page-"+currPage+"-item-1'>Here is item #1</a></li></ul>");



        //create a feature container

        $("#settings-area").append("<div id='container-list-feature-" + listCount + "-page-" + currPage + "' class='feature-container list-container'></div>");





        //create heading

        $("#container-list-feature-" + listCount + "-page-" + currPage).append("<h4>List Settings</h4>");



        //create a hidden title area for list feature

        $("#container-list-feature-" + listCount + "-page-" + currPage).append("<input type='hidden' name='appy-options-list-title-" + listCount + "-page-" + currPage + "' />");



        //create repeatable list input area

        $("#container-list-feature-" + listCount + "-page-" + currPage).append("<label for='list-repeatable-" + listCount + "-page-" + currPage + "'>List Items</label>");

        $("#container-list-feature-" + listCount + "-page-" + currPage).append("<div class='list-repeatable-container' id='list-repeatable-container-" + listCount + "-page-" + currPage + "'></div><br style='clear:both;' /><span class='add-list-item'>Add a list item +</span>");

        $("#container-list-feature-" + listCount + "-page-" + currPage + " .list-repeatable-container").append("<input name='appy-options-list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-title' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1' class='list-repeatable-item' value='Here is item #1'/><span class='delete-list-item'>-</span><div class='hidden-options-toggle' style='margin-top:-5px;'>Toggle Options</div><div id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-options' class='hidden-options-area' style='display:none;'><label for='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-link-type'>Link type</label><select name='appy-options-list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-link-type' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-link-type' class='list-item-option-link-type'><option value='empty'>No link, just text</option><option value='internal'>Another page on this site</option><option value='external'>External page</option></select><label style='display:none;' for='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-external-link'>Link URL</label><input style='display:none;' name='appy-options-list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-external-link' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-external-link' value='http://' class='list-item-option-external-link' /><label style='display:none;' for='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-internal-link'>Choose Page</label><select style='display:none;' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-internal-link' class='list-item-options-list-pages'></select><input name='appy-options-list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-internal-link-hidden' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-1-option-internal-link-hidden' type='hidden' class='hidden-internal-link' /></div>");



        //create delete button

        $("#container-list-feature-" + listCount + "-page-" + currPage).append("<div class='delete-list-button delete-button-settings'>Delete this feature</div>");



        //create the scroll bar

        $('.list-repeatable-container').slimscroll({

            height: '414px',

			size: '10px',

            disableFadeOut: true

        });

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);



    }







    //this will create settings for a NEW divider feature

    function createDividerSettings(ui) {



        //add a divider class to the item on the screen

        $(ui.item).attr("class", "screen-divider");

        $(ui.item).addClass("on-screen-feature");

        $(ui.item).empty();



        //get current page

        var currPage = $("#current-page").text();



        //get number of dividers on this current page and ammend ID

        var dividerCount = $("#screen-page-" + currPage + " .screen-divider").length;

        $(ui.item).attr("id", "screen-divider-" + dividerCount + "-page-" + currPage);



        //append a divider area to the screen feature

        $(ui.item).append("<div class='screen-divider-feature' />");



        //create a feature container

        $("#settings-area").append("<div id='container-divider-" + dividerCount + "-page-" + currPage + "' class='feature-container divider-container'></div>");



        //create heading

        $("#container-divider-" + dividerCount + "-page-" + currPage).append("<h4>Divider Settings</h4>");



        //create drop down area for options

        $("#container-divider-" + dividerCount + "-page-" + currPage).append("<div class='hidden-options-toggle'>Toggle Options</div>");

        $("#container-divider-" + dividerCount + "-page-" + currPage).append("<div class='hidden-options-area' id='options-divider-" + dividerCount + "-page-" + currPage + "' style='display:none;'></div>");



        //create padding top input

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<label class='padding-top' for='divider-padding-top-" + dividerCount + "-page-" + currPage + "'>Padding Top</label>");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<div class='slider-bar padding-top' />");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<input value='10' name='appy-options-divider-padding-top-" + dividerCount + "-page-" + currPage + "' id='divider-padding-top-" + dividerCount + "-page-" + currPage + "'>");





        //create padding bottom input

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<label class='padding-bottom' for='divider-padding-bottom-" + dividerCount + "-page-" + currPage + "'>Padding Bottom</label>");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<div class='slider-bar padding-bottom' />");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<input value='10' name='appy-options-divider-padding-bottom-" + dividerCount + "-page-" + currPage + "' id='divider-padding-bottom-" + dividerCount + "-page-" + currPage + "'><br />");





        //create height input

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<label class='height' for='divider-height-" + dividerCount + "-page-" + currPage + "'>Height</label>");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<div class='slider-bar height' />");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<input value='3' name='appy-options-divider-height-" + dividerCount + "-page-" + currPage + "' id='divider-height-" + dividerCount + "-page-" + currPage + "'><br />");





        //create width input

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<label class='width' for='divider-width-" + dividerCount + "-page-" + currPage + "'>Width</label>");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<div class='slider-bar width' />");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<input value='90' name='appy-options-divider-width-" + dividerCount + "-page-" + currPage + "' id='divider-width-" + dividerCount + "-page-" + currPage + "'><br />");



        //create border-radius input

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<label class='border-radius' for='divider-border-radius-" + dividerCount + "-page-" + currPage + "'>Corner Round</label>");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<div class='slider-bar border-radius' />");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<input value='2' name='appy-options-divider-border-radius-" + dividerCount + "-page-" + currPage + "' id='divider-border-radius-" + dividerCount + "-page-" + currPage + "'><br />");



        //create color input

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<label for='divider-color-" + dividerCount + "-page-" + currPage + "'>Color</label>");

        $("#options-divider-" + dividerCount + "-page-" + currPage).append("<input value='#999999' name='appy-options-divider-color-" + dividerCount + "-page-" + currPage + "' id='divider-color-" + dividerCount + "-page-" + currPage + "' class='divider-color'><br />");





        //create delete button

        $("#container-divider-" + dividerCount + "-page-" + currPage).append("<div class='delete-divider-button delete-button-settings'>Delete this feature</div>");





        $(".slider-bar.padding-top").slider({

            animate: "slow",

            min: 0,

            max: 100,

            step: 1,

			value: 10

        });

        $(".slider-bar.padding-bottom").slider({

            animate: "slow",

            min: 0,

            max: 100,

            step: 1,

			value: 10

        });

        $(".slider-bar.height").slider({

            animate: "slow",

            min: 0,

            max: 50,

            step: 1,

			value: 3

        });

        $(".slider-bar.width").slider({

            animate: "slow",

            min: 0,

            max: 100,

            step: 1,

			value: 90

        });

        $(".slider-bar.border-radius").slider({

            animate: "slow",

            min: 0,

            max: 30,

            step: 1,

			value: 2

        });



        //color for divider

        $(".divider-color").spectrum({

			color: "#999999",

            showInput: true,

            className: "full-spectrum",

            showInitial: true,

            showPalette: true,

            maxPaletteSize: 10,

            preferredFormat: "hex",

            showButtons: false,

            move: function (color) {

                $("#smart-screen li#screen-divider-" + $(this).attr("id").substr(14) + " .screen-divider-feature").css("background-color", color.toHexString());

            },

            change: function (color) {

                $("#smart-screen li#screen-divider-" + $(this).attr("id").substr(14) + " .screen-divider-feature").css("background-color", color.toHexString());

            }

        });

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);



    }







    //this will create settings for a NEW social links feature

    function createSocialSettings(ui) {



        //add a social class to the item on the screen

        $(ui.item).attr("class", "screen-social");

        $(ui.item).addClass("on-screen-feature");

        $(ui.item).html("<ul><li class='social-screen-message'><span class='social-screen-warning'>Use the menu on the right to add social links to this area</span></li></ul>");



        //get current page

        var currPage = $("#current-page").text();



        //get number of social lists on this current page and ammend ID

        var socialCount = $("#screen-page-" + currPage + " .screen-social").length;

        $(ui.item).attr("id", "screen-social-" + socialCount + "-page-" + currPage);



        //create a feature container

        $("#settings-area").append("<div id='container-social-" + socialCount + "-page-" + currPage + "' class='feature-container social-container'></div>");



        //create heading

        $("#container-social-" + socialCount + "-page-" + currPage).append("<h4>Social Settings</h4>");



        //create options area for feature

        $("#container-social-" + socialCount + "-page-" + currPage).append("<div class='hidden-options-toggle'>Toggle Options</div>");

        $("#container-social-" + socialCount + "-page-" + currPage).append("<div class='hidden-options-area' id='options-social-" + socialCount + "-page-" + currPage + "' style='display:none;'></div>");



        //create badge set option

        $("#options-social-" + socialCount + "-page-" + currPage).append("<label for='badge-set-social-" + socialCount + "-page-" + currPage + "'>Badge Set</label><select name='appy-options-badge-set-social-" + socialCount + "-page-" + currPage + "' id='badge-set-social-" + socialCount + "-page-" + currPage + "'><option value='badges1'>Default</option><option value='badges2'>Set 2</option><option value='badges3'>Set 3</option><option value='badges4'>Set 4</option><option value='badges5'>Set 5</option><option value='badges6'>Set 6</option><option value='badges7'>Set 7</option><option value='badges8'>Set 8</option></select>");



        //create container div to hold social site settings

        $("#container-social-" + socialCount + "-page-" + currPage).append("<div class='social-container' id='social-container-" + socialCount + "-page-" + currPage + "'></div>");



        //create boxes for each social site

        $("#container-social-" + socialCount + "-page-" + currPage).append("<div class='social-settings-icons-box'><ul><li class='facebook-icon social-icon'><p>Facebook</p></li><li class='twitter-icon social-icon'><p>Twitter</p></li><li class='linkedin-icon social-icon'><p>LinkedIn</p></li><li class='youtube-icon social-icon'><p>YouTube</p></li><li class='googleplus-icon social-icon'><p>GooglePlus</p></li><li class='flickr-icon social-icon'><p>Flickr</p></li><li class='tumblr-icon social-icon'><p>Tumblr</p></li><li class='wordpress-icon social-icon'><p>Wordpress</p></li><li class='blogger-icon social-icon'><p>Blogger</p></li></ul><div class='social-settings-drag-into'><ul><span>Drag social sites into this area to add them to the screen. Then, click on the icon to edit the settings for each site.</span></ul></div>");



        //make the droppable and sortable area

        $("div.social-settings-drag-into ul").droppable({

            scope: "social-create",

            accept: ".social-settings-icons-box ul li:not('.in-list')",

            drop: function (event, ui) {

                $("li.social-screen-message").slideUp();

                $(".hidden-social-options").slideUp();

                $(ui.draggable).addClass('in-list');

                $(this).append($(ui.draggable));

                var currSocial = $(this).parents(".feature-container").attr("id").substr(17);

                var currSite = $(ui.draggable).children("p").text().toLowerCase().replace(' ', '-');

                $("#container-social-" + currSocial + " div.social-settings-drag-into").append("<div style='display:none;' class='hidden-social-options' id='social-options-" + currSocial + "-" + currSite + "'><h5>" + currSite + " Options</h5><label for='social-options-" + currSocial + "-" + currSite + "-linkurl'>Link To</label><input name='appy-options-social-options-" + currSocial + "-" + currSite + "-linkurl' id='social-options-" + currSocial + "-" + currSite + "-linkurl' /><label for='social-options-" + currSocial + "-" + currSite + "-link-window'>Open In New Window?</label><select name='appy-options-social-options-" + currSocial + "-" + currSite + "-link-window' id='social-options-" + currSocial + "-" + currSite + "-link-window'><option value='yes'>Yes</option><option value='no'>No</option></select><div class='delete-social-site'>Delete this site</div></div>");



                $("#social-options-" + currSocial + "-" + currSite).slideDown();



                //make a new badge on the screen

                var currPage = $("#current-page").text(),

                    backImage = $(ui.draggable).css("background-image");

                $("li#screen-social-" + currSocial + " ul li.social-screen-message").slideUp();

                $("li#screen-social-" + currSocial + " ul").append("<li style='background-image:" + backImage + "' class='screen-social-badge' id='screen-social-" + currSocial + "-" + currSite + "'></li>");

                var currLocation = socialCount + "-page-" + currPage;

				changeOutBadgeGraphics(currLocation);

            }

        });



        //make the list of social sites draggable

        $("div.social-settings-icons-box ul li").draggable({

            scope: "social-create",

            helper: "clone",

            revert: "invalid"



        });

		

		$("#container-social-" + socialCount + "-page-" + currPage).append("<div class='delete-divider-button delete-button-settings'>Delete this feature</div>");

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);

    }







    //this will create settings for a NEW button feature

    function createButtonSettings(ui) {



        //add a paragraph class to the item on the screen

        $(ui.item).attr("class", "screen-button");

        $(ui.item).addClass("on-screen-feature");



        //add button class

		var thisBackColor = $("#site-option-button-color").spectrum("get");

		var thisColor = $("#site-option-button-text-color").spectrum("get");

        $(ui.item).html("<div class='screen-button-feature' style='background-color:" + thisBackColor +";color:"+thisColor+";'>Button</div>");



        //get current page

        var currPage = $("#current-page").text();



        //get number of paragraphs on this current page and ammend ID

        var buttonCount = $("#screen-page-" + currPage + " .screen-button").length;

        $(ui.item).attr("id", "screen-button-" + buttonCount + "-page-" + currPage);



        //create a feature container

        $("#settings-area").append("<div id='container-button-" + buttonCount + "-page-" + currPage + "' class='feature-container button-container'></div>");



        //create a title

        $("#container-button-" + buttonCount + "-page-" + currPage).append("<h4>Button Settings</h4>");



        //create content textarea

        $("#container-button-" + buttonCount + "-page-" + currPage).append("<label for='button-text-" + buttonCount + "-page-" + currPage + "'>Button Text</label>");

        $("#container-button-" + buttonCount + "-page-" + currPage).append("<textarea name='appy-options-button-text-" + buttonCount + "-page-" + currPage + "' class='button-text-area' id='button-text-" + buttonCount + "-page-" + currPage + "'>Button</textarea><br />");



        //create drop down area for options

        $("#container-button-" + buttonCount + "-page-" + currPage).append("<div class='hidden-options-toggle'>Toggle Options</div>");

        $("#container-button-" + buttonCount + "-page-" + currPage).append("<div class='hidden-options-area' id='options-button-" + buttonCount + "-page-" + currPage + "' style='display:none;'></div>");



        //create link options option

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<label for='button-options-link-type-" + buttonCount + "-page-" + currPage + "'>Link type</label><select name='appy-options-button-options-link-type-" + buttonCount + "-page-" + currPage + "' id='button-options-link-type" + buttonCount + "-page-" + currPage +"' class='button-option-link-type'><option value='empty'>No link, just text</option><option value='internal'>Another page on this site</option><option value='external'>External page</option></select><label style='display:none;' for='button-options-external-link-" + buttonCount + "-page-" + currPage + "'>Link URL</label><input style='display:none;' name='appy-options-button-options-external-link-" + buttonCount + "-page-" + currPage + "' id='button-options-external-link-" + buttonCount + "-page-" + currPage + "' value='http://' class='button-option-external-link' /><label style='display:none;' for='button-options-internal-link-" + buttonCount + "-page-" + currPage + "'>Choose Page</label><select style='display:none;' id='button-options-internal-link-" + buttonCount + "-page-" + currPage + "' class='button-options-list-pages'></select><input name='appy-options-button-options-internal-link-hidden" + buttonCount + "-page-" + currPage + "' id='button-options-internal-link-hidden-" + buttonCount + "-page-" + currPage + "' type='hidden' class='hidden-internal-link' /></div>");





        //create width option

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<label class='width' for='button-width-" + buttonCount + "-page-" + currPage + "'>Button Width</label>");

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<div class='slider-bar button-width' />");

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<input name='appy-options-button-width-" + buttonCount + "-page-" + currPage + "' id='button-width-" + buttonCount + "-page-" + currPage + "' value='40'><br />");



        //create height option

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<label class='line-height' for='button-height-" + buttonCount + "-page-" + currPage + "'>Button Height</label>");

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<div class='slider-bar button-height' />");

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<input name='appy-options-button-height-" + buttonCount + "-page-" + currPage + "' id='button-height-" + buttonCount + "-page-" + currPage + "' value='35'><br />");



        //create font-size option

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<label class='font-size' for='button-font-size-" + buttonCount + "-page-" + currPage + "'>Font Size</label>");

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<div class='slider-bar font-size' />");

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<input name='appy-options-button-font-size-" + buttonCount + "-page-" + currPage + "' id='button-font-size-" + buttonCount + "-page-" + currPage + "' value='14'><br />");



        //create border-radius option

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<label class='border-radius' for='button-border-radius-" + buttonCount + "-page-" + currPage + "'>Border Radius</label>");

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<div class='slider-bar border-radius' />");

        $("#options-button-" + buttonCount + "-page-" + currPage).append("<input name='appy-options-button-border-radius-" + buttonCount + "-page-" + currPage + "' id='button-border-radius-" + buttonCount + "-page-" + currPage + "' value='4'><br />");

		

		$("#options-button-" + buttonCount + "-page-" + currPage).append("<div class='delete-header-area-button delete-button-settings'>Delete this feature</div>");







        $(".slider-bar.button-width").slider({

            animate: "slow",

            min: 23,

            max: 100,

            step: 1,

			value:40

        });

        $(".slider-bar.button-height").slider({

            animate: "slow",

            min: 15,

            max: 90,

            step: 1,

			value: 35

        });

        $(".slider-bar.font-size").slider({

            animate: "slow",

            min: 9,

            max: 50,

            step: 1,

			value: 14

        });

        $(".slider-bar.border-radius").slider({

            animate: "slow",

            min: 0,

            max: 40,

            step: 1,

			value: 4

        });

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);









    }





	//this will create settings for a NEW button feature

    function createTapToCallSettings(ui) {



        //add a paragraph class to the item on the screen

        $(ui.item).attr("class", "screen-tap-call");

        $(ui.item).addClass("on-screen-feature");



        //add button class

		var thisBackColor = $("#site-option-button-color").spectrum("get");

		var thisColor = $("#site-option-button-text-color").spectrum("get");

        $(ui.item).html("<div class='screen-tap-call-feature' style='background-color: "+thisBackColor+";color:"+thisColor+"'>Tap To Call</div>");



        //get current page

        var currPage = $("#current-page").text();



        //get number of paragraphs on this current page and ammend ID

        var tapCallCount = $("#screen-page-" + currPage + " .screen-tap-call").length;

        $(ui.item).attr("id", "screen-tap-call-" + tapCallCount + "-page-" + currPage);



        //create a feature container

        $("#settings-area").append("<div id='container-tap-call-" + tapCallCount + "-page-" + currPage + "' class='feature-container tap-call-container'></div>");



        //create a title

        $("#container-tap-call-" + tapCallCount + "-page-" + currPage).append("<h4>Tap To Call Settings</h4>");



        //create content textarea

        $("#container-tap-call-" + tapCallCount + "-page-" + currPage).append("<label for='tap-call-text-" + tapCallCount + "-page-" + currPage + "'>Tap To Call Text</label>");

        $("#container-tap-call-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-call-text-" + tapCallCount + "-page-" + currPage + "' class='tap-call-text-area' id='tap-call-text-" + tapCallCount + "-page-" + currPage + "' value='Tap To Call'/><br />");

		

		//create link options option

        $("#container-tap-call-" + tapCallCount + "-page-" + currPage).append("<label for='tap-call-options-number-" + tapCallCount + "-page-" + currPage + "'>Phone Number</label><input name='appy-options-tap-call-options-number-" + tapCallCount + "-page-" + currPage + "' id='tap-call-options-number-" + tapCallCount + "-page-" + currPage + "' value='1234567890' class='tap-call-option-number' />");



        //create drop down area for options

        $("#container-tap-call-" + tapCallCount + "-page-" + currPage).append("<div class='hidden-options-toggle'>Toggle Options</div>");

        $("#container-tap-call-" + tapCallCount + "-page-" + currPage).append("<div class='hidden-options-area' id='options-tap-call-" + tapCallCount + "-page-" + currPage + "' style='display:none;'></div>");



        





        //create width option

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<label class='width' for='tap-call-width-" + tapCallCount + "-page-" + currPage + "'>Button Width</label>");

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<div class='slider-bar tap-call-width' />");

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-call-width-" + tapCallCount + "-page-" + currPage + "' id='tap-call-width-" + tapCallCount + "-page-" + currPage + "' value='40'><br />");



        //create height option

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<label class='line-height' for='tap-call-height-" + tapCallCount + "-page-" + currPage + "'>Button Height</label>");

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<div class='slider-bar tap-call-height' />");

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-call-height-" + tapCallCount + "-page-" + currPage + "' id='tap-call-height-" + tapCallCount + "-page-" + currPage + "' value='35'><br />");



        //create font-size option

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<label class='font-size' for='tap-call-font-size-" + tapCallCount + "-page-" + currPage + "'>Font Size</label>");

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<div class='slider-bar tap-call-font-size' />");

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-call-font-size-" + tapCallCount + "-page-" + currPage + "' id='tap-call-font-size-" + tapCallCount + "-page-" + currPage + "' value='14'><br />");



        //create border-radius option

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<label class='border-radius' for='tap-call-border-radius-" + tapCallCount + "-page-" + currPage + "'>Border Radius</label>");

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<div class='slider-bar tap-call-border-radius' />");

        $("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-call-border-radius-" + tapCallCount + "-page-" + currPage + "' id='tap-call-border-radius-" + tapCallCount + "-page-" + currPage + "' value='4'><br />");

		

		$("#options-tap-call-" + tapCallCount + "-page-" + currPage).append("<div class='delete-header-area-button delete-button-settings'>Delete this feature</div>");







        $(".slider-bar.tap-call-width").slider({

            animate: "slow",

            min: 23,

            max: 100,

            step: 1,

			value:40

        });

        $(".slider-bar.tap-call-height").slider({

            animate: "slow",

            min: 15,

            max: 90,

            step: 1,

			value: 35

        });

        $(".slider-bar.tap-call-font-size").slider({

            animate: "slow",

            min: 9,

            max: 50,

            step: 1,

			value: 14

        });

        $(".slider-bar.tap-call-border-radius").slider({

            animate: "slow",

            min: 0,

            max: 40,

            step: 1,

			value: 4

        });

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);









    }



	//this will create settings for a NEW tap to email feature

    function createTapToEmailSettings(ui) {



        //add a paragraph class to the item on the screen

        $(ui.item).attr("class", "screen-tap-email");

        $(ui.item).addClass("on-screen-feature");



        //add button class

       var thisBackColor = $("#site-option-button-color").spectrum("get");

		var thisColor = $("#site-option-button-text-color").spectrum("get");

        $(ui.item).html("<div class='screen-tap-email-feature' style='background-color: "+thisBackColor+";color:"+thisColor+"'>Tap To Email</div>");



        //get current page

        var currPage = $("#current-page").text();



        //get number of paragraphs on this current page and ammend ID

        var tapCallCount = $("#screen-page-" + currPage + " .screen-tap-email").length;

        $(ui.item).attr("id", "screen-tap-email-" + tapCallCount + "-page-" + currPage);



        //create a feature container

        $("#settings-area").append("<div id='container-tap-email-" + tapCallCount + "-page-" + currPage + "' class='feature-container tap-email-container'></div>");



        //create a title

        $("#container-tap-email-" + tapCallCount + "-page-" + currPage).append("<h4>Tap To Email Settings</h4>");



        //create content textarea

        $("#container-tap-email-" + tapCallCount + "-page-" + currPage).append("<label for='tap-email-text-" + tapCallCount + "-page-" + currPage + "'>Tap To Email Text</label>");

        $("#container-tap-email-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-email-text-" + tapCallCount + "-page-" + currPage + "' class='tap-email-text-area' id='tap-email-text-" + tapCallCount + "-page-" + currPage + "' value='Tap To Email Us'/><br />");

		

		//create link options option

        $("#container-tap-email-" + tapCallCount + "-page-" + currPage).append("<label for='tap-email-options-address-" + tapCallCount + "-page-" + currPage + "'>Email Address</label><input name='appy-options-tap-email-options-address-" + tapCallCount + "-page-" + currPage + "' id='tap-email-options-address-" + tapCallCount + "-page-" + currPage + "' value='you@domain.com' class='tap-email-option-address' />");



        //create drop down area for options

        $("#container-tap-email-" + tapCallCount + "-page-" + currPage).append("<div class='hidden-options-toggle'>Toggle Options</div>");

        $("#container-tap-email-" + tapCallCount + "-page-" + currPage).append("<div class='hidden-options-area' id='options-tap-email-" + tapCallCount + "-page-" + currPage + "' style='display:none;'></div>");



        





        //create width option

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<label class='width' for='tap-email-width-" + tapCallCount + "-page-" + currPage + "'>Button Width</label>");

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<div class='slider-bar tap-email-width' />");

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-email-width-" + tapCallCount + "-page-" + currPage + "' id='tap-email-width-" + tapCallCount + "-page-" + currPage + "' value='40'><br />");



        //create height option

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<label class='line-height' for='tap-email-height-" + tapCallCount + "-page-" + currPage + "'>Button Height</label>");

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<div class='slider-bar tap-email-height' />");

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-email-height-" + tapCallCount + "-page-" + currPage + "' id='tap-email-height-" + tapCallCount + "-page-" + currPage + "' value='35'><br />");



        //create font-size option

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<label class='font-size' for='tap-email-font-size-" + tapCallCount + "-page-" + currPage + "'>Font Size</label>");

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<div class='slider-bar tap-email-font-size' />");

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-email-font-size-" + tapCallCount + "-page-" + currPage + "' id='tap-email-font-size-" + tapCallCount + "-page-" + currPage + "' value='14'><br />");



        //create border-radius option

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<label class='border-radius' for='tap-email-border-radius-" + tapCallCount + "-page-" + currPage + "'>Border Radius</label>");

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<div class='slider-bar tap-email-border-radius' />");

        $("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<input name='appy-options-tap-email-border-radius-" + tapCallCount + "-page-" + currPage + "' id='tap-email-border-radius-" + tapCallCount + "-page-" + currPage + "' value='4'><br />");

		

		$("#options-tap-email-" + tapCallCount + "-page-" + currPage).append("<div class='delete-header-area-button delete-button-settings'>Delete this feature</div>");







        $(".slider-bar.tap-email-width").slider({

            animate: "slow",

            min: 23,

            max: 100,

            step: 1,

			value:40

        });

        $(".slider-bar.tap-email-height").slider({

            animate: "slow",

            min: 15,

            max: 90,

            step: 1,

			value: 35

        });

        $(".slider-bar.tap-email-font-size").slider({

            animate: "slow",

            min: 9,

            max: 50,

            step: 1,

			value: 14

        });

        $(".slider-bar.tap-email-border-radius").slider({

            animate: "slow",

            min: 0,

            max: 40,

            step: 1,

			value: 4

        });

		

		var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

		$("#screen-page-"+currPage+"-order").val(screenOrder);









    }











    //------Functions needed for settings - clicks and such



    //reveal hidden options for social sites

    $("#settings-area").on("click", ".open-social-settings", function () {

        $(this).next(".hidden-options-area").slideToggle();

    });







    //reveal hidden options area for features

    $("#settings-area").on("click", ".hidden-options-toggle", function () {

        $(this).next(".hidden-options-area").slideToggle();



        if ($(this).css("left") == "169px") {

            $(this).css("font-style", "normal").css("font-weight", "normal");

            $(this).text("Toggle Options");

            $(this).animate({

                "width": "86px",

                    "background-color": "#777",

                    "left": "0px",

                    "marginBottom": "5px"

            }, "slow", "easeOutBack");











        } else {





            $(this).css("position", "relative").css("font-style", "italic").css("font-weight", "bold");

            $(this).text("Close");

            $(this).animate({

                "left": "169px",

                    "marginBottom": "-15px",

                    "width": "48px",

                    "background-color": "#888"

            }, "slow", "easeOutBack");



            //if this is for a list item option, adjust the page dropdown

            if ($(this).prev(".delete-list-item")) {

				var currArea = $(this).next("div.hidden-options-area").attr("id");

				currArea = currArea.substring(0, currArea.length - 8);

				currArea = currArea.substring(21);

				$("#list-repeatable-list-"+currArea+"-option-internal-link").empty();

                $("#page-selection option").each(function (index) {

                    var pageTitle = $(this).val();

					pageTitle = $("#page-settings-area-holder #page-title-"+pageTitle).val();

                    $("#list-repeatable-list-"+currArea+"-option-internal-link").append("<option value='" + pageTitle + "'>" + pageTitle + "</option>");

                });

				var currLink = $(this).next("div.hidden-options-area").find(".hidden-internal-link").val();

				$(this).next("div.hidden-options-area").find(".list-item-options-list-pages").val(currLink);

					if ($(this).next("div.hidden-options-area").find(".list-item-option-link-type").val() == 'internal') {

						$(this).next("div.hidden-options-area").find(".list-item-options-list-pages").show();

					}

            }

            //if this is for a button link option, adjust the page dropdown

            if ($(this).parents(".button-container")) {

				var currArea = $(this).next("div.hidden-options-area").attr("id");

				currArea = currArea.substring(15);

				$("#button-options-internal-link-"+currArea+" option").remove();

                $("#page-selection option").each(function (index) {

                    var pageTitle = $(this).val();

					pageTitle = $("#page-settings-area-holder #page-title-"+pageTitle).val();

                    $("#button-options-internal-link-"+currArea).append("<option value='" + pageTitle + "'>" + pageTitle + "</option>");

                });

				var currLink = $(this).next("div.hidden-options-area").find(".hidden-internal-link").val();

				$(this).next("div.hidden-options-area").find(".button-options-list-pages").val(currLink);

					if ($(this).next("div.hidden-options-area").find(".button-option-link-type").val() == 'internal') {

						$(this).next("div.hidden-options-area").find(".button-options-list-pages").show();

					}

            }

        }

    });

	

	

	//fix to reload page options in button internal link dropdown when focus is on dropdown

	$("#settings-area").on("focus", ".button-options-list-pages", function() {

		var currArea = $(this).parents("div.hidden-options-area").attr("id");

		currArea = currArea.substring(15);

		$("#button-options-internal-link-"+currArea+" option").remove();

		$("#page-selection option").each(function (index) {

			var pageTitle = $(this).val();

			pageTitle = $("#page-settings-area-holder #page-title-"+pageTitle).val();

			$("#button-options-internal-link-"+currArea).append("<option value='" + pageTitle + "'>" + pageTitle + "</option>");

		});

	});



    //this controls the add repeatable list item button

    $("#settings-area").on("click", "span.add-list-item", function () {



        //get current page

        var currPage = $("#current-page").text();



        //get number of lists on this current page and ammend ID

        var listCount = $("#screen-page-" + currPage + " .screen-list-feature").length;



        //get number of list items already present

        var listItemCount = $("#settings-area #list-repeatable-container-" + listCount + "-page-" + currPage + " input.list-repeatable-item").size();



        //create the new list item and set it to display:none

        $("#settings-area #list-repeatable-container-" + listCount + "-page-" + currPage).append("<input name='appy-options-list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + (++listItemCount) + "-title' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "' class='list-repeatable-item' style='display:none;' value='Here is item #" + listItemCount + "'/><span class='delete-list-item'>-</span><div class='hidden-options-toggle' style='margin-top:-5px;'>Toggle Options</div><div id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-options' class='hidden-options-area' style='display:none;'><label for='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-link-type'>Link type</label><select name='appy-options-list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-link-type' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-link-type' class='list-item-option-link-type'><option value='empty'>No link, just text</option><option value='internal'>Another page on this site</option><option value='external'>External page</option></select><label style='display:none;' for='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-external-link'>Link URL</label><input style='display:none;' name='appy-options-list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-external-link' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-external-link' value='http://' class='list-item-option-external-link' /><label style='display:none;' for='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-internal-link'>Choose Page</label><select style='display:none;' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-internal-link' class='list-item-options-list-pages'></select><input name='appy-options-list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-internal-link-hidden' id='list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "-option-internal-link-hidden' type='hidden' class='hidden-internal-link' /></div>");





        //slide in the new list item

        $("#list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount).slideDown();

        $("#list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount).next("span.delete-list-item").slideDown();

        $("#list-repeatable-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount).nextAll("div.hidden-options-toggle").slideDown();



        //now add a list item to the visible screen

        $("#screen-list-feature-list-" + listCount + "-page-" + currPage).append("<li style='background-color:"+ ($("#site-option-list-background-color").val()) +";color:"+ ($("#site-option-list-item-color").val()) +"' id='screen-list-feature-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "'><a style='font-size:"+ ($("#site-option-list-item-size").val()) +"' class='inside-list-item' id='inside-list-" + listCount + "-page-" + currPage + "-item-" + listItemCount + "'>Here is item #" + listItemCount + "</a></li></ul>");







    });







    //this controls the delete repeatable list item button

    $("#settings-area").on("click", "span.delete-list-item", function () {

        $(this).prev("input").addClass("deleted").slideUp();

        $(this).next("div.hidden-options-toggle").addClass("deleted").slideUp();



        var listInfo = $(this).prev("input").attr("id").substr(16);

        $("#screen-page-" + $("#current-page").text() + " li#screen-list-feature-" + listInfo).addClass("deleted").hide();

        $(this).slideUp().remove();

    });







    //change the list item text on screen when settings input is changed

    $("#settings-area").on("keyup", ".list-repeatable-container input.list-repeatable-item", function () {

        var listInfo = $(this).attr("id").substr(16);

        $("#screen-page-" + $("#current-page").text() + " li#screen-list-feature-" + listInfo + " a.inside-list-item").text($(this).val());

    });





    //list item options

    $("#settings-area").on("change", ".list-item-option-link-type", function () {

        if ($(this).val() == 'external') {

            var parentID = $(this).parent().attr("id");

            $("#" + parentID + " .list-item-options-list-pages").hide().prev("label").hide();

            $("#" + parentID + " .list-item-option-external-link").fadeIn().prev("label").fadeIn();

        } else if ($(this).val() == 'internal') {

            var parentIDi = $(this).parent().attr("id");

            $("#" + parentIDi + " .list-item-option-external-link").hide().prev("label").hide();

            $("#" + parentIDi + " .list-item-options-list-pages").fadeIn().prev("label").fadeIn();

			$("#" + parentIDi + " .list-item-options-list-pages").next(".hidden-internal-link").val($("#" + parentIDi + " .list-item-options-list-pages").val());

        } else if ($(this).val() == 'empty') {

            var parentIDe = $(this).parent().attr("id");

            $("#" + parentIDe + " .list-item-option-external-link").fadeOut().prev("label").fadeOut();

            $("#" + parentIDe + " .list-item-options-list-pages").fadeOut().prev("label").fadeOut();

        }

    });

    //this passes the internal link choice into a hidden field so the pages dropdown can be emptied when the options area is hidden, that way, it can be updated with current pages once it is shown again

    $("#settings-area").on("change", ".list-item-options-list-pages", function () {

        $(this).next(".hidden-internal-link").val($(this).val());

    });





	$("#site-settings-options-area").on("change", "#site-option-list-item-size", function () {

        $("#smart-screen li.screen-list-feature ul li a").css("font-size", $(this).val());

    });



















    //BUTTON SETTINGS



    $("#settings-area").on("keyup", ".button-text-area", function () {

        var currButton = $(this).attr("id").substr(12);

        $("#smart-screen li#screen-button-" + currButton + " div").html($(this).val().replace(/\r\n|\r|\n/g,"<br />"));

    });



    //CLICK TO CALL SETTINGS



    $("#settings-area").on("keyup", ".tap-call-text-area", function () {

        var currButton = $(this).attr("id").substr(14);

        $("#smart-screen li#screen-tap-call-" + currButton + " div").html($(this).val().replace(/\r\n|\r|\n/g,"<br />"));

    });



    //CLICK TO EMAIL SETTINGS



    $("#settings-area").on("keyup", ".tap-email-text-area", function () {

        var currButton = $(this).attr("id").substr(15);

        $("#smart-screen li#screen-tap-email-" + currButton + " div").html($(this).val().replace(/\r\n|\r|\n/g,"<br />"));

    });









	

	

	//HEADER SETTINGS - Functions to change the smart screen

	$("#settings-area").on("keyup", ".header-content-area", function () {

        var currContent = $(this).attr("id").substr(15);

        $("#screen-header-" + currContent + " h1").text($(this).val());

    });

	

	$("#site-settings-options-area").on("change", "#site-option-heading-size", function () {

        $(".screen-header h1").css("font-size", $(this).val());

    });

	$("#site-settings-options-area").on("change", "#site-option-heading-font", function () {

        $(".screen-header h1").css("font-family", $(this).val());

    });

	

	

	

	//IMAGE SETTINGS

	

	$("#settings-area").on("slide", ".image-container .slider-bar", function (event, ui) {

        $(this).next("input").val(ui.value);

        var toChange = $(this).prev("label").attr("class");

        var changeElement = $(this).parents(".feature-container").attr("id").substr(10);

			if (toChange == 'width') {

				$("#smart-screen li#screen-" + changeElement+" img").css(toChange, ui.value + "%");

			} else if ((toChange == 'padding-bottom')||(toChange == 'padding-top')) {

				$("#smart-screen li#screen-" + changeElement).css(toChange, ui.value + "px");

			} else {

				$("#smart-screen li#screen-" + changeElement+" img").css(toChange, ui.value + "px");

			}



    });



	$("#settings-area").on("change", ".image-container .box-shadow-option", function (event, ui) {

		if ($(this).val() == 'yes') {

			var changeElement = $(this).parents(".feature-container").attr("id").substr(10);

			$("#smart-screen li#screen-" + changeElement+" img").css('box-shadow', '0px 2px 4px rgba(81,81,81,.7)');

		} else {

			var changeElement = $(this).parents(".feature-container").attr("id").substr(10);

			$("#smart-screen li#screen-" + changeElement+" img").css('box-shadow', 'none');

		}

    });





    //TEXT AREA SETTINGS - Functions to change the smart screen



    //Change the text areas when a settings input is changed

    $("#settings-area").on("keyup", ".text-content-area", function () {

        var currContent = $(this).attr("id").substr(13);

        $("#screen-text-" + currContent+" .inside-screen-text").html($(this).val().replace(/\r\n|\r|\n/g,"<br />"));

    });

    $("#settings-area").on("slide", ".text-container .slider-bar", function (event, ui) {

        $(this).next("input").val(ui.value);

        var toChange = $(this).prev("label").attr("class");

        var changeElement = $(this).parents(".feature-container").attr("id").substr(10);

        $("#smart-screen li#screen-" + changeElement).css(toChange, ui.value + "px");



    });

    $("#settings-area").on("change", ".text-alignment-select", function () {

        var currContent = $(this).attr("id").substr(15);

        $("#screen-text-" + currContent).css("text-align", $(this).val());

    });

	$("#settings-area").on("change", ".site-option-body-font", function () {

        $("#smart-screen").css("font-family", $(this).val());

    });

    $("#settings-area").on("change", ".text-style-selector", function () {

        var currContent = $(this).attr("id").substr(11);

        if ($(this).val() == 'normal') {

            $("#screen-text-" + currContent).css("font-weight", "normal");

            $("#screen-text-" + currContent).css("font-style", "normal");

        }

        if ($(this).val() == 'bold') {

            $("#screen-text-" + currContent).css("font-weight", "bold");

            $("#screen-text-" + currContent).css("font-style", "normal");

        }

        if ($(this).val() == 'italic') {

            $("#screen-text-" + currContent).css("font-weight", "normal");

            $("#screen-text-" + currContent).css("font-style", "italic");

        }

        if ($(this).val() == 'bold-italic') {

            $("#screen-text-" + currContent).css("font-weight", "bold");

            $("#screen-text-" + currContent).css("font-style", "italic");

        }

    });

    $("#settings-area").on("change focus", ".text-line-height", function () {

        var currContent = $(this).attr("id").substr(17);

        $("#screen-text-" + currContent+" .inside-screen-text").css("line-height", $(this).val());

    });











    //Clear the settings currently showing on the screen

    function clearCurrentSettings() {

        $("#settings-area .feature-container").delay(400).slideUp(10);

    }



    //Show settings when a screen feature is clicked on

    $("#smart-screen-visible").on("click", ".screen-list li.on-screen-feature", function () {

			$("#left-settings-accordion").animate({

                width: "17%"

            }, "slow", "swing", function () {

                $("#site-settings-options-area").hide();

            });

        closeSettingsPanel();

        clearCurrentSettings();

			var thisID = $(this).attr("id").substr(7);

        $("#settings-area #container-" + thisID).delay(400).slideDown(10);

        openSettingsPanel();

    });



    //Close the settings box, so users don't see switching of data

    function closeSettingsPanel() {

        $("#settings-area").animate({

            "margin-left": "-352px"

        }, 300);



    }



    //Open the settings box

    function openSettingsPanel() {

        $("#settings-area").delay(400).animate({

            "margin-left": "0px"

        }, 300);

    }



    // This closes the settings panel when the x is clicked

    $("#close-settings").on("click", closeSettingsPanel);





    // DELETE A FEATURE

    $("#settings-area").on("click", ".delete-button-settings", function () {

        var currArea = $(this).parents(".feature-container").attr("id");

        $("#holder").append("<div class='delete-message-dialog delete-warning-text' id='delete-" + currArea + "'>Are you sure that you want to <strong>DELETE</strong> this feature?<br />This CANNOT be undone!</div>");

        $(".delete-message-dialog").dialog({

            open: function () {

                $(".ui-dialog-buttonpane").find("button:contains('DELETE')").addClass("big-delete-button");

            },

            modal: true,

            width: "385px",

            closeText: "Close This",

            height: "auto",

            hide: "fade",

            show: "fade",

            title: "Are You Sure??",

            resizable: false,

            buttons: {

                Cancel: function () {

                    $(this).dialog("close");

                },

                    'DELETE IT': function () {

                    var toDelete = $(this).attr("id").substr(17);

                    var currPage = $("#current-page").text();

                    $("#smart-screen-visible li#screen-" + toDelete).addClass("deleted");

                    $("#smart-screen-visible li#screen-" + toDelete).hide();

                    $("#settings-area #container-" + toDelete + " input, #settings-area #container-" + toDelete + " select, #settings-area #container-" + toDelete + " textarea").each(function () {

                        var currname = $(this).attr("name");

                        $(this).attr("name", currname + "-deleted");

                    });

					$("#smart-screen li#screen-"+toDelete).attr("id", "");

					

					var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

					$("#screen-page-"+currPage+"-order").val(screenOrder);

					var tempOrder = $("#screen-page-"+currPage+"-order").val();

					  tempOrder = tempOrder.replace(",,",",");

					  $("#screen-page-"+currPage+"-order").val(tempOrder);

                    

					closeSettingsPanel();

                    $(this).dialog("close");

                }

            },

            close: function (event, ui) {

                $(".delete-message-dialog").remove();

            }

        });

    });









    // DIVIDER SETTINGS



    $("#settings-area").on("slide", ".divider-container .slider-bar", function (event, ui) {

        $(this).next("input").val(ui.value);

        var toChange = $(this).prev("label").attr("class");

        var changeElement = $(this).parents(".feature-container").attr("id").substr(10);

        if ((toChange == "padding-top") || (toChange == "padding-bottom")) {

            $("#smart-screen li#screen-" + changeElement).css(toChange, ui.value + "px");

        } else if ((toChange == "height") || (toChange == "border-radius")) {

            $("#smart-screen li#screen-" + changeElement + " div.screen-divider-feature").css(toChange, ui.value + "px");

        } else if (toChange == "width") {

            $("#smart-screen li#screen-" + changeElement + " div.screen-divider-feature").css("width", ui.value + "%");

        }



    });









    // BUTTON SETTINGS



    $("#settings-area").on("slide", ".slider-bar", function (event, ui) {

        $(this).next("input").val(ui.value);

        var toChange = $(this).prev("label").attr("class");

        var changeElement = $(this).parents(".feature-container").attr("id").substr(10);

        if ((toChange == "font-size") || (toChange == "border-radius")) {

            $("#smart-screen li#screen-" + changeElement + " div").css(toChange, ui.value + "px");

        } else if (toChange == "line-height") {

            $("#smart-screen li#screen-" + changeElement + " div").css("line-height", ui.value + "px").css("height", ui.value + "px");

        } else if (toChange == "width") {

            $("#smart-screen li#screen-" + changeElement + " div").css("width", ui.value + "%");

        }



    });



    //list item options

    $("#settings-area").on("change", ".button-option-link-type", function () {

        if ($(this).val() == 'external') {

            var parentID = $(this).parent().attr("id");

            $("#" + parentID + " .button-options-list-pages").hide().prev("label").hide();

            $("#" + parentID + " .button-option-external-link").fadeIn().prev("label").fadeIn();

        } else if ($(this).val() == 'internal') {

            var parentIDi = $(this).parent().attr("id");

            $("#" + parentIDi + " .button-option-external-link").hide().prev("label").hide();

            $("#" + parentIDi + " .button-options-list-pages").fadeIn().prev("label").fadeIn();

        } else if ($(this).val() == 'empty') {

            var parentIDe = $(this).parent().attr("id");

            $("#" + parentIDe + " .button-option-external-link").fadeOut().prev("label").fadeOut();

            $("#" + parentIDe + " .button-options-list-pages").fadeOut().prev("label").fadeOut();

        }

    });

    //this passes the internal link choice into a hidden field so the pages dropdown can be emptied when the options area is hidden, that way, it can be updated with current pages once it is shown again

    $("#settings-area").on("change", ".button-options-list-pages", function () {

        $(this).next(".hidden-internal-link").val($(this).val());

    });









    // SOCIAL SITES



    // ammend social site badsges when they are dragged to the sortable list

    function recieveSocialSite(event, ui) {



        //make sure that any settings areas are closed

        $(".social-site-settings-area").slideUp("fast");





        $(ui.item).addClass("in-social-sites-list");

        var currSocial = $(ui.item).parents(".feature-container").attr("id").substr(10);



        $(ui.item).append("<div class='open-social-settings' />");





        //get current page

        var currPage = $("#current-page").text(),

            currSite = $(ui.item).text().toLowerCase().replace(" ", "-");



        if ($("#container-" + currSocial + " .social-settings-drag-into li." + currSite + "-icon").size() > 1) {

            $(ui.item).remove();

            $(".social-settings-icons-box ul:last").append("<div class='social-too-many-warning'>Only one instance of each social site allowed</div>");

            $(".social-too-many-warning").slideDown().effect("highlight").delay(3000);

            $(".social-too-many-warning").slideUp("fast", function () {

                $(this).remove();

            });

            return;

        }



        //add a hidden options area

        $(ui.item).attr("id", currSite + "-" + currSocial).append("<div class='hidden-options-area social-site-settings-area' style='display:none;'><label for='link-" + currSite + "-" + currSocial + "'>Link to</label><input id='link-" + currSite + "-" + currSocial + "'/><label for='open-" + currSite + "-" + currSocial + "'>Open in new window?</label><select id='open-" + currSite + "-" + currSocial + "'><option value='no'>No</option><option value='yes'>Yes</option></select><div class='delete-social-site'>Remove this site</div></div>");



        //remove warning instruction message if present

        $("#smart-screen .social-screen-warning").remove();



        //add a social badge to the visible screen

        $("#smart-screen li#screen-" + currSocial).append("<div id='screen-" + currSite + "-" + currSocial + "' class='screen-badge-" + currSite + " screen-social-badge'><p>" + currSite + "</p></div>");



    }



    // delete a social site from the list

    $("#settings-area").on("click", ".delete-social-site", function () {

        var currLocation = $(this).parents(".feature-container").attr("id").substr(17),

            currSite = $(this).parents(".hidden-social-options").attr("id");

        currSite = currSite.replace("social-options-" + currLocation + "-", "");

        $("#social-options-" + currLocation + "-" + currSite + " input, #social-options-" + currLocation + "-" + currSite + " select").each(function () {

            var currname = $(this).attr("name");

            $(this).attr("name", currname + "-deleted");

        });

        $(this).parents(".hidden-social-options").slideUp();

        $(".social-settings-drag-into li." + currSite + "-icon").slideUp();



        //add the site back into the draggable area



        $(".social-settings-icons-box ul:first").append("<li class='" + currSite + "-icon social-icon ui-draggable'><p>" + currSite + "</p></li>");

		var currLocation = $(this).parents(".feature-container").attr("id").substr(17)

			changeOutBadgeGraphics(currLocation);



        //make the list of social sites draggable

        $("div.social-settings-icons-box ul li").draggable({

            scope: "social-create",

            helper: "clone",

            revert: "invalid"



        });

        $("#smart-screen ul li#screen-social-" + currLocation + "-" + currSite).slideUp().remove();



        if ($("#smart-screen li#screen-social-" + currLocation + " ul li").length == 1) {

            $("li#screen-social-" + currLocation + " li.social-screen-message").slideDown();

        }









    });









    // clicking on a social badge in the settings area

    $("#settings-area").on("click", ".social-settings-drag-into li.in-list", function () {

        var currSite;

        currSite = $(this).text().toLowerCase(),

        currSite = currSite.replace(" ", "-"),

        currPage = $(this).parents(".feature-container").attr("id").substr(17);



        if ($("#social-options-" + currPage + "-" + currSite).css('display') !== 'none') {

            $("#social-options-" + currPage + "-" + currSite).slideUp();

        } else {

            $(".hidden-social-options").slideUp();

            $("#social-options-" + currPage + "-" + currSite).slideDown();

        }









    });





    //changing the badge set alignment

    $("#settings-area").on("change", "[name*='alignment-set-social']", function () {

        currSocial = $(this).attr("id").substr(17);

        if (($(this).val() == 'left') || ($(this).val() == 'right')) {

            $("#smart-screen li#screen-social-" + currSocial + " ul").css('float', $(this).val());

        } else {

            $("#smart-screen li#screen-social-" + currSocial + " ul").css('float', 'none');

        }



    });



    //changing the badge set graphics

    $("#settings-area").on("change", "[name*='-badge-set-social-']", function () {

		var currLocation = $(this).parent(".hidden-options-area").attr("id").substr(15)

        changeOutBadgeGraphics(currLocation);



    });





    function changeOutBadgeGraphics(currLocation) {

        var newbadgeSet = $("#settings-area .hidden-options-area[id*='"+currLocation+"'] [name*='-badge-set-social-']").val(), //badges2

			currBadgeurl = $("#settings-area div[id*='"+currLocation+"'] li.twitter-icon").css("background-image"),

			currBadge = currBadgeurl.replace(/["']{1}/gi,""); //url(http://f.com/wp-content/plugins/appy/includes/images/d.pn)

			currBadge = currBadge.replace("url",""); //(http://f.com/wp-content/plugins/appy/includes/images/d.pn)

			currBadge = currBadge.replace("(",""); //http://f.com/wp-content/plugins/appy/includes/images/d.pn)

			currBadgeurl = currBadge.replace(")",""); //http://f.com/wp-content/plugins/appy/includes/images/d.pn

			currBadge = currBadgeurl.substring(currBadgeurl.indexOf("/includes/images/") + 17); //badges1/twitter.png")

			currBadge = currBadge.replace(/["']{1}/gi,""); //badges1/twitter.png)

			currBadge = currBadge.substring(0, currBadge.length - 12); //badges1

			

		var newBadgeurl = currBadgeurl.replace(currBadge, newbadgeSet),

			newBadgeurlBase = newBadgeurl.substring(0, newBadgeurl.length - 11),

			currBadgeurlBase = currBadgeurl.substring(0, currBadgeurl.length - 11);



        if (newbadgeSet == "badges2") {

            $("#settings-area div[id*='"+currLocation+"'] li.social-icon").each(function() {

				var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

				$(this).css("background-size", "37px auto")

				$(this).css("background-position", "-2px -2px");

			

			});

			

			

			$("#smart-screen li.screen-social-badge").each(function() {

				var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange);

				$(this).css("background-size", "67px auto");

				$(this).css("background-position", "-4px -5px");

			});



        } else if (newbadgeSet == "badges3" || newbadgeSet == "badges4") {

			$("#smart-screen li.screen-social-badge").each(function() {

				var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

                $(this).css("background-size", "64px auto");

                $(this).css("background-position", "-3px -2px");

            });

            $("#settings-area div[id*='"+currLocation+"'] li.social-icon").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

            });

        } else if (newbadgeSet == "badges6") {

            $("#smart-screen li.screen-social-badge").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

                $(this).css("background-size", "86px auto");

                $(this).css("background-position", "-14px -14px");

            });

            $("#settings-area div[id*='"+currLocation+"'] li.social-icon").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

            });

		} else if (newbadgeSet == "badges5") {

            $("#smart-screen li.screen-social-badge").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

                $(this).css("background-size", "64px auto");

                $(this).css("background-position", "-3px 0px");

            });

            $("#settings-area div[id*='"+currLocation+"'] li.social-icon").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

            });

        } else if (newbadgeSet == "badges7" || newbadgeSet == "badges8") {

            $("#smart-screen li.screen-social-badge").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

                $(this).css("background-size", "56px auto");

                $(this).css("background-position", "center center");

            });

            $("#settings-area div[id*='"+currLocation+"'] li.social-icon").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

            });

        } else if (newbadgeSet == "badges1"){

            $("#smart-screen li.screen-social-badge").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

            });

            $("#settings-area div[id*='"+currLocation+"'] li.social-icon").each(function () {

                var toChange = $(this).css("background-image");

				toChange = toChange.replace(currBadgeurlBase, newBadgeurlBase);

				$(this).css("background-image", toChange)

            });

        }

    }















    //add a new page on 'New Page'

    //counts number of pages, then adds a sortable area on the page so features can be dropped onto it

    $("#add-a-page").on("click", addANewPage);

	

	

	

	

	//DELETE A PAGE!!!

    $("#delete-current-page").on("click", function(){

		closeSettingsPanel()

		

		if ($("#total-page-count").val() == 1) {

		

		

		var currPage = $("#current-page").text();

        $("#holder").append("<div class='delete-message-dialog delete-warning-text' id='delete-page" + currPage + "'>You can't delete your only page! Try to make others first, or you could just delete this site all together.</div>");

        $(".delete-message-dialog").dialog({

            open: function () {

                $(".ui-dialog-buttonpane").find("button:contains('DELETE')").addClass("big-delete-button");

            },

            modal: true,

            width: "385px",

            closeText: "Close This",

            height: "auto",

            hide: "fade",

            show: "fade",

            title: "Can't Delete This Page",

            resizable: false,

            buttons: {

                Okay: function () {

                    $(this).dialog("close");

                },

            },

            close: function (event, ui) {

                $(".delete-message-dialog").remove();

            }

		

		});

		} else {

		

		

		var currPage = $("#current-page").text();

        $("#holder").append("<div class='delete-message-dialog delete-warning-text' id='delete-page" + currPage + "'>Are you sure that you want to <strong>DELETE</strong> this page?<br />This CANNOT be undone!</div>");

        $(".delete-message-dialog").dialog({

            open: function () {

                $(".ui-dialog-buttonpane").find("button:contains('DELETE')").addClass("big-delete-button");

            },

            modal: true,

            width: "385px",

            closeText: "Close This",

            height: "auto",

            hide: "fade",

            show: "fade",

            title: "Are You Sure??",

            resizable: false,

            buttons: {

                Cancel: function () {

                    $(this).dialog("close");

                },

                    'DELETE IT': function () {

                    var toDelete = $(this).attr("id").substr(17);

						var deletePage = $("#current-page").text();

						

						//move the order input field out of the smart screen so it isn't deleted

						$("#screen-page-"+deletePage+"-order").insertAfter("#close-settings");

						var orderDelete = $("#screen-page-"+deletePage+"-order").attr("name");

							$("#screen-page-"+deletePage+"-order").attr("name", orderDelete+"-hidden");

						

						//decrease the total page count by 1

						//var currentVal = $("#total-page-count").val();

						//	$("#total-page-count").val(--currentVal);

						

						

						//remove form smart screen



						//$("#smart-screen #screen-page-"+deletePage).remove();

					

					

						//remove page as an option in the 'go to page' dropdown

						$("#page-selection option[value='"+deletePage+"']").remove();

						

						

						

						//amend all page features settings to deleted

						$("#settings-area .feature-container[id*='page-"+deletePage+"'] input, #settings-area .feature-container[id*='page-"+deletePage+"'] select, #settings-area .feature-container[id*='page-"+deletePage+"'] textarea").each(function() {

							var currName = $(this).attr("name");

							$(this).attr("name", currName+"-deleted");

						});



						

						$("#page-settings-area-holder .page-settings-container[id*='page-"+deletePage+"'] input, #page-settings-area-holder .page-settings-container[id*='page-"+deletePage+"'] select").each(function() {

							var currName = $(this).attr("name");

							$(this).attr("name", currName+"-deleted");

						});

						

						



							

						$("#bottom-menu-holder #page-"+deletePage+"-bottom-menu").slideUp("fast")

						

						

						$("#page-settings-area-holder .page-settings-container[id*='page-"+deletePage+"']").hide();

						

						

						

						

						$("#current-page").text($("#page-selection option").first().val());

						goToNewPage();

                    $(this).dialog("close");

                }

            },

            close: function (event, ui) {

                $(".delete-message-dialog").remove();

            }

        });

		

		

		

	}	



	});

	

	





    // Jump to page selector

    $("#page-selection").on("change focus", goToNewPage);





    // this function chanes the current page shown on the screen

    function goToNewPage() {

        clearCurrentSettings();

        clearPageSettings();

        var currPage = $("#page-selection").val(),

            offSet = (currPage - 1) * 480; //this must be screen height

        $("#smart-screen-visible").css("top", "-" + offSet + "px");

        $("#current-page").text(currPage);

        $("#page-settings-area-holder #page-" + currPage + "-settings-container").show(); //show the correct page settings

        closeSettingsPanel();

    }





    //this function will add a new page to the mobile site

    function addANewPage() {

        var noPages = $("#smart-screen-visible > div").length;

        $("<div class='screen-page' id='screen-page-" + (++noPages) + "'><ul class='screen-list'></ul></div>").appendTo("#smart-screen-visible");

		//make the screen area scrollable if it gets too large

			$('.screen-page').slimscroll({

				height: '480px',

				disableFadeOut: true

			});

			

			

        $(".screen-list").sortable({

            axis: "y",

            helper: "clone",

            update: function (event, ui) {

                if ($(ui.item).is('[class*=on-screen-feature]')) {

				//update the current order

                var currPage = $("#current-page").text();

				var screenOrder = $( "#screen-page-"+currPage+" .screen-list" ).sortable( "toArray" );

				$("#screen-page-"+currPage+"-order").val(screenOrder);

                } else {

                    checkNewFeatureType(event, ui);

                }

            }

        });

		

		$("#screen-page-" + noPages).append("<input type='hidden' id='screen-page-"+noPages+"-order' name='appy-options-screen-page-"+noPages+"-order'/>");

		

		$("#total-page-count").val(noPages);



        //add page number to page select drop down

        $("<option selected value='" + noPages + "'>" + noPages + "</option>").appendTo("#page-selection");

        goToNewPage();



        //add page to menus, even if they're not shown

        $("#bottom-menu-holder #inside-bottom-menu").append("<div style='color:"+ $("#site-option-bottom-menu-text-color").val() +";' id='page-" + noPages + "-bottom-menu' class='bottom-menu-item'><span>Page " + noPages + "</span></div>");

        $("#side-menu-actual ul").append("<li id='page-" + noPages + "-side-menu' class='side-menu-item'><a><span>Page " + noPages + "</span></a></li>");

			if ($("#site-menu-icon-option").val() == 'icons') {

				$(".bottom-menu-item").addClass("icon home").css("margin-top", "5px");

				$(".bottom-menu-item span").slideUp("fast");

			} if ($("#site-menu-icon-option").val() == 'icons-text') {

				$(".bottom-menu-item").addClass("icon home").css("margin-top", "0px").css("font-size", "12px").css("line-height", "67px");;

				$(".bottom-menu-item span").slideDown("fast");

			} if ($("#site-menu-icon-option").val() == 'text') {

				$(".bottom-menu-item span").slideDown("fast");

				$(".bottom-menu-item").css("font-size", "14px").css("line-height", "43px").css("margin-top", "0px");

			}



			

        clearPageSettings();



		

        //add a holder for this page's settings

        $("#page-settings-area-holder").append("<div id='page-" + noPages + "-settings-container' class='page-settings-container'></div>");



        //add title input field

        $("#page-" + noPages + "-settings-container").append("<label for='page-title-" + noPages + "'>Page Title</label><br /><input name='appy-options-page-title-"+noPages+"' id='page-title-" + noPages + "' value='Page " + noPages + "' class='page-title-option' type='text' /><br />");



        //add menu option field

        $("#page-" + noPages + "-settings-container").append("<label for='page-option-include-in-menu-" + noPages + "'>Include page in menus?</label><br /><select name='appy-options-page-option-include-in-menu-"+ noPages +"' class='page-in-menu-option' id='page-option-include-in-menu-" + noPages + "'><option value='yes'>Yes</option><option value='no'>No</option></select><br />");

		

		//add icon option field

        $("#page-" + noPages + "-settings-container").append("<label for='page-option-menu-icon-" + noPages + "'>Menu Icon</label><br /><select name='appy-options-page-option-menu-icon-" + noPages + "' class='icon-in-menu-option' id='page-option-menu-icon-" + noPages + "'><option value='home'>Home</option><option value='pencil'>Pencil</option><option value='picture'>Picture</option><option value='camera'>Camera</option><option value='headset'>Headset</option><option value='paper'>Paper</option><option value='stack'>Stack</option><option value='folder'>Folder</option><option value='tag'>Tag</option><option value='basket'>Basket</option><option value='phone'>Phone</option><option value='mail'>Mail</option><option value='location'>Location</option><option value='clock'>Clock</option><option value='calendar'>Calendar</option><option value='message'>Message</option><option value='chat'>Chat</option><option value='user'>User</option><option value='loading'>Loading</option><option value='refresh'>Refresh</option><option value='magnifier'>Magnifier</option><option value='key'>Key</option><option value='settings'>Settings</option><option value='graph'>Graph</option><option value='trash'>Trash</option><option value='pin'>Pin</option><option value='target'>Target</option><option value='download'>Download</option><option value='upload'>Upload</option><option value='star'>Star</option><option value='heart'>Heart</option><option value='warning'>Warning</option><option value='add'>Add</option><option value='remove'>Remove</option><option value='question'>Question</option><option value='info'>Info</option><option value='error'>Error</option><option value='check'>Check</option><option value='minimize'>Minimize</option><option value='close'>Close</option><option value='up'>Up</option><option value='down'>Down</option><option value='left'>Left</option><option value='right'>Right</option><option value='tools'>Tools</option><option value='html5'>Html5</option><option value='css'>Css</option><option value='js'>Js</option><option value='cloud'>Cloud</option><option value='tv'>Tv</option><option value='wifi'>Wifi</option><option value='new'>New</option><option value='mic'>Mic</option><option value='database'>Database</option><option value='busy'>Busy</option><option value='bug'>Bug</option><option value='lamp'>Lamp</option></select>");

		

		//add icon option field

        $("#page-" + noPages + "-settings-container").append("<div id='icon-preview-" + noPages + "' class='page-icon-preview icon big home'></div>");



    }



    function clearPageSettings() {

        $("#page-settings-area-holder .page-settings-container").hide();

    }





    // clear page in menus - change function to hide page in menus when set to 'yes'

    $("#page-settings-area-holder").on("change focus", "select.page-in-menu-option", function () {

        var toHide = $("#current-page").text();

        if ($(this).val() == "no") {

            $("#bottom-menu-holder div#page-" + toHide + "-bottom-menu").slideUp();

        } else {

            $("#bottom-menu-holder div#page-" + toHide + "-bottom-menu").slideDown();

        }



    });





    // got to a new page when a menu item is clicked

    $("#bottom-menu-holder").on("click", ".bottom-menu-item", function () {

        var goToPage = $(this).attr("id").substr(5);

        goToPage = goToPage.split('-')[0];

        $("#page-selection").val(goToPage);

        goToNewPage();

    });



    $("#side-menu-actual").on("click", ".side-menu-item", function () {

        var goToPage = $(this).attr("id").substr(5);

        goToPage = goToPage.split('-')[0];

        $("#page-selection").val(goToPage);

        goToNewPage();

    });









    // Header options and settings affecting header

    $("#use-header-option").on("change", function () {

        if ($(this).val() == "yes") {

            $("#header-holder").slideDown();

            $("#sitewide-header-option-holder").slideDown();

            $("#smart-screen").animate({

                top: "+=48"

            });

        } else {

            $("#header-holder").slideUp();

            $("#sitewide-header-option-holder").slideUp();

            $("#smart-screen").animate({

                top: "136px"

            });

        }

    });





    $("#site-menu-option").on("change", function () {

        if ($(this).val() == "yes") {

            $("#bottom-menu-holder").slideDown();

		} if ($(this).val() == "no") {

            $("#bottom-menu-holder").slideUp();

		}

    });









    //changing the page title

    $("#page-settings-area-holder").on("change", ".page-title-option", function () {

        var currPage = $(this).attr("id").substr(11);

        $("#bottom-menu-holder div#page-" + currPage + "-bottom-menu span").text($(this).val());

    });

	

	

	//changing the menu icon preview

	$("#page-settings-area-holder").on("change", ".icon-in-menu-option", function() {

	

		var changeTo = $(this).val(),

			currPage = $("#current-page").text();

		$("#icon-preview-"+currPage).attr("class", "page-icon-preview icon big "+changeTo);

		 $("#bottom-menu-holder div#page-" + currPage + "-bottom-menu").attr("class", "bottom-menu-item icon "+$(this).val());

		});







    //Clicking to active side menu

    $("#side-menu-activate-holder").on("click", function () {

        if ($("#side-menu-actual").css("margin-left") !== "0px") {

            $("#side-menu-actual").animate({

                marginLeft: "0px"

            }, "fast");

            $("#smart-screen-visible").animate({

                left: "200px"

            }, "fast");

            $("#side-menu-activate-holder").fadeOut();

        }

    });



    //clicking to close the side menu

    $("#close-side-menu").on("click", function () {

        $("#side-menu-actual").animate({

            marginLeft: "-200px"

        }, "fast");

        $("#smart-screen-visible").animate({

            left: "0px"

        }, "fast");

        $("#side-menu-activate-holder").fadeIn();

    });



	

	

	//change the content of the bottom nav links

	$("#site-settings-options-area").on("change", "#site-menu-icon-option", function() {

		if ($(this).val() == 'text') {

			$("#inside-bottom-menu .bottom-menu-item").removeClass("icon");

			$("#inside-bottom-menu div.bottom-menu-item").css("font-size", "14px").css("line-height", "43px").css("margin-top", "0px");

			$("#inside-bottom-menu div.bottom-menu-item span").slideDown("fast");

		} if ($(this).val() == 'icons') {

			$("#inside-bottom-menu div.bottom-menu-item").css("margin-top", "5px");

			$("#inside-bottom-menu div.bottom-menu-item").addClass("icon");

			$("#inside-bottom-menu div.bottom-menu-item span").slideUp("fast");

		} if ($(this).val() == 'icons-text') {

			$("#inside-bottom-menu div.bottom-menu-item").css("margin-top", "0px").css("font-size", "12px").css("line-height", "67px");

			$("#inside-bottom-menu div.bottom-menu-item").addClass("icon");

			$("#inside-bottom-menu div.bottom-menu-item span").slideDown("fast");

		}

	});



	

	

	

	

	function returnCloneHelper() {

	return $(this).clone().attr('class', 'ui-draggable-dragging').css('height', '50px');

}

	

	





	

	

	



});